# Währungen im Iran Plugin

Ein WordPress-Plugin, das Wechselkurse in Echtzeit von iranischen Finanz-Websites scrapt und anzeigt.

## Funktionen

- **Echtzeitkurse**: Automatisches Scraping von USD-Wechselkursen von mehreren iranischen Quellen
- **Mehrere Quellen**: Derzeit unterstützt:
  - [EghtesadNews](https://www.eghtesadnews.com/markets/dollar)
  - [Tgju](https://www.tgju.org/profile/price_dollar_rl)
- **Mehrsprachige Unterstützung**: Vollständige Internationalisierung mit persischen und deutschen Übersetzungen
- **Caching-System**: Verwendet WordPress Transients API für effizientes Caching (15 Minuten Standard)
- **Admin-Dashboard**: Umfassende Admin-Oberfläche zur Anzeige von Kursen und Verwaltung von Einstellungen
- **Shortcode-Unterstützung**: Kurse überall auf Ihrer Website mit Shortcodes anzeigen
- **Automatische Updates**: WP-Cron-Integration für geplante Kurs-Updates
- **Fehlerbehandlung**: Robuste Fehlerprotokollierung und Validierung
- **Responsives Design**: Mobilfreundliche Frontend-Anzeige
- **Erweiterbare Architektur**: Einfaches Hinzufügen neuer Quellen und Währungen

## Anforderungen

- WordPress 6.0+
- PHP 7.4+
- DOM- und cURL-Erweiterungen aktiviert

## Installationsanweisungen

### Methode 1: WordPress-Admin (Empfohlen)
1. Gehen Sie in Ihrem WordPress-Admin zu **Plugins → Hinzufügen → Plugin hochladen**
2. Klicken Sie auf **Datei auswählen** und wählen Sie die Datei `currencies-in-iran.zip`
3. Klicken Sie auf **Jetzt installieren**
4. Klicken Sie auf **Aktivieren**
5. Konfigurieren Sie die Einstellungen unter **Währungen im Iran → Einstellungen**

### Methode 2: Manuelles FTP/SFTP
1. Laden Sie das Plugin-ZIP herunter und extrahieren Sie es
2. Laden Sie den Ordner `currencies-in-iran` nach `/wp-content/plugins/` hoch
3. Gehen Sie im WordPress-Admin zu **Plugins → Installierte Plugins**
4. Finden Sie **Währungen im Iran** und klicken Sie auf **Aktivieren**
5. Konfigurieren Sie die Einstellungen unter **Währungen im Iran → Einstellungen**

### Methode 3: Entwicklungs-Setup
1. Klonen Sie das Repository nach `/wp-content/plugins/currencies-in-iran/`
2. Stellen Sie sicher, dass die Dateiberechtigungen korrekt sind (755 für Verzeichnisse, 644 für Dateien)
3. Aktivieren Sie das Plugin im WordPress-Admin

## Häufig gestellte Fragen

**F: Wie oft werden die Kurse aktualisiert?**
A: Kurse werden automatisch alle 15 Minuten über WP-Cron aktualisiert. Sie können auch manuell über das Admin-Dashboard aktualisieren.

**F: Kann ich Kurse im Frontend anzeigen?**
A: Ja! Verwenden Sie den Shortcode `[currencies_in_iran]` überall in Ihren Beiträgen, Seiten oder Widgets.

**F: Welche Währungen werden unterstützt?**
A: Derzeit nur USD (US-Dollar zu Iranischer Rial). Weitere Währungen können leicht hinzugefügt werden.

**F: Was passiert, wenn eine Quell-Website nicht erreichbar ist?**
A: Das Plugin funktioniert weiterhin mit verfügbaren Quellen und protokolliert Fehler. Sie sehen Fehlermeldungen im Admin-Dashboard.

**F: Kann ich das Anzeigeformat anpassen?**
A: Ja! Der Shortcode unterstützt mehrere Optionen wie `format="table"`, `show_average="true"` und `sources="eghtesadnews,tgju"`.

**F: Ist das Plugin sicher für meine Website?**
A: Ja! Das Plugin befolgt WordPress-Sicherheitspraktiken, verwendet ordnungsgemäße Datenbereinigung und enthält Nonce-Verifizierung.

**F: Wie kann ich eine neue Währungsquelle hinzufügen?**
A: Erstellen Sie eine neue PHP-Datei in `includes/sources/{currency}/`, die `CurrencyInterface` implementiert. Das Plugin erkennt sie automatisch.

**F: Verlangsamt dieses Plugin meine Website?**
A: Nein! Kurse werden 15 Minuten lang zwischengespeichert, sodass Scraping nur periodisch erfolgt, nicht bei jedem Seitenaufruf.

## Änderungsprotokoll

### Version 0.1.6 (8. Dezember 2025)
- **Hinzugefügt**: Vollständige Internationalisierungsunterstützung mit persischen und deutschen Übersetzungen
- **Erstellt**: Vollständige .po/.mo Sprachdateien für fa_IR und de_DE Locales
- **Aktualisiert**: Plugin zur Verwendung von WordPress-Standard-Text-Domain-Ladung
- **Verbessert**: Mehrsprachige Admin-Oberfläche und Frontend-Anzeige
- **Optimiert**: Benutzererfahrung für nicht-englischsprachige Benutzer
- **Standardisiert**: Übersetzungsbereite Architektur nach WordPress-Best Practices

### Version 0.1.5 (8. Dezember 2025)
- **Behoben**: EghtesadNews-Scraper mit präzisen Selektoren für Preis-Tabellen-Struktur
- **Verbessert**: EghtesadNews-Muster zum Extrahieren der Haupt-"دلار"-Zeile (andere Dollar-Typen ausschließen)
- **Hinzugefügt**: Toman-zu-Rial-Konvertierung für EghtesadNews (1 Toman = 10 Rial)
- **Verbessert**: Scoring-Algorithmus zur Priorisierung exakter Tabellenstruktur-Muster
- **Aktualisiert**: Selektoren zum Ausschließen von "دلار کانادا", "دلار در صرافی ملی", etc.
- **Getestet**: Bestätigte Funktion mit Live-Daten, korrekten Kurs extrahierend (1.242.500 IRR)
- **Ergebnis**: Beide Scraper arbeiten jetzt mit konsistenten Kursen innerhalb von 2.000 IRR Unterschied

### Version 0.1.4 (8. Dezember 2025)
- **Behoben**: AJAX-Funktionalität für Aktualisierungs- und Cache-Lösch-Schaltflächen
- **Behoben**: Fehlende Methoden in CacheManager-Klasse, die zu fatalen Fehlern führten
- **Verbessert**: Tgju-Scraper mit gezielten Selektoren für "نرخ فعلی" (aktueller Kurs)
- **Erweitert**: Kurs-Validierung für realistische USD-Bereiche (1.1M-1.5M IRR)
- **Hinzugefügt**: JavaScript-Ladezustände und Benutzerbenachrichtigungen
- **Hinzugefügt**: Umfassende Fehlerbehandlung und Protokollierung
- **Umstrukturiert**: CurrencyInterface in Quellverzeichnis für bessere Organisation verschoben
- **Hinzugefügt**: Quell-Validierungssystem mit Debug-Protokollierung
- **Verbessert**: Admin-Dashboard mit besserer visueller Rückmeldung

### Version 0.1 (8. Dezember 2025)
- **Erste Veröffentlichung**: Grundlegende USD-Kurs-Scraping von EghtesadNews und Tgju
- **Hinzugefügt**: WordPress-Admin-Dashboard für Kurs-Verwaltung
- **Hinzugefügt**: Shortcode-System für Frontend-Anzeige
- **Hinzugefügt**: Caching-System mit 15-Minuten-Ablauf
- **Hinzugefügt**: WP-Cron-Integration für automatische Updates
- **Hinzugefügt**: Fehlerprotokollierung und Validierung
- **Hinzugefügt**: Responsives CSS-Styling für Admin und Frontend
- **Hinzugefügt**: Erweiterbare Quellarchitektur unter Verwendung von Interfaces

## Zusätzliche Informationen

### Plugin-Architektur
Das Plugin verwendet eine modulare, erweiterbare Architektur:

```
currencies-in-iran/
├── currencies-in-iran.php          # Haupt-Plugin-Datei
├── includes/
│   ├── sources/                    # Währungsquellen-Implementierungen
│   │   ├── CurrencyInterface.php   # Standardvertrag für alle Quellen
│   │   ├── class-source-loader.php # Verhindert Konflikte und verwaltet das Laden
│   │   └── usd/                # USD-Währungsquellen
│   │       ├── eghtesadnews.php  # EghtesadNews-Scraper
│   │       └── tgju.php         # Tgju-Scraper
│   ├── class-admin.php            # Admin-Dashboard
│   ├── class-cache-manager.php     # Caching-System
│   ├── class-shortcode.php       # Frontend-Shortcode
│   └── class-source-manager.php   # Quell-Verwaltung
├── languages/                    # Sprachdateien
│   ├── currencies-in-iran-fa_IR.po # Persische Übersetzung
│   └── currencies-in-iran-de_DE.po # Deutsche Übersetzung
└── assets/
    ├── css/                      # Stylesheets
    └── js/                       # JavaScript-Dateien
```

### Datenquellen
- **EghtesadNews**: Scrapet von https://www.eghtesadnews.com/markets/dollar
- **Tgju**: Scrapet von https://www.tgju.org/profile/price_dollar_rl
- Beide Quellen bieten USD zu IRR (Iranischer Rial) Wechselkurse
- Daten werden validiert und zwischengespeichert, um Genauigkeit und Leistung sicherzustellen

### Sicherheitsfunktionen
- **Nonce-Verifizierung**: Alle AJAX-Anfragen enthalten WordPress-Nonces
- **Fähigkeitsprüfungen**: Admin-Funktionen erfordern `manage_options` Fähigkeit
- **Datenbereinigung**: Alle Benutzereingaben und -ausgaben werden ordnungsgemäß escaped
- **Ratenbegrenzung**: Respektiert Quell-Websites mit ordnungsgemäßen Anfrageintervallen
- **Fehlerprotokollierung**: Umfassende Protokollierung ohne Offenlegung sensibler Informationen

### Leistungsoptimierungen
- **Caching**: 15-Minuten-Cache reduziert Serverlast
- **Effizientes Scraping**: Mehrere Extraktionsstrategien mit Scoring
- **Minimale Datenbankabfragen**: Verwendet WordPress-Optionen und Transients effizient
- **Lazy Loading**: Quellen werden nur bei Bedarf geladen
- **Komprimierte Assets**: CSS und JS sind in der Produktion ordnungsgemäß minimiert

## Andere Hinweise

### Entwicklung & Erweiterbarkeit
- **Namespace**: Aller Code verwendet `AliKhaleghi\CurrenciesInIran` Namespace
- **Hooks**: Plugin bietet WordPress-Hooks für Anpassungen
- **Filter**: Daten können mit WordPress-Filtern geändert werden
- **Actions**: Ereignisse können mit WordPress-Actions erweitert werden
- **Debug-Modus**: Aktivieren Sie `WP_DEBUG`, um detaillierte Quell-Validierungsprotokolle zu sehen

### Browser-Kompatibilität
- **Moderne Browser**: Volle Unterstützung für Chrome, Firefox, Safari, Edge
- **Mobil-Responsiv**: Für alle Bildschirmgrößen optimiert
- **Graceful Degradation**: Funktioniert ohne JavaScript (Grundfunktionalität)
- **Progressive Enhancement**: Verbesserte Funktionen mit aktiviertem JavaScript

### WordPress-Integration
- **Multisite-kompatibel**: Funktioniert auf WordPress-Multisite-Installationen
- **Übersetzungsbereit**: Verwendet WordPress i18n-Funktionen
- **Coding-Standards**: Befolgt WordPress-Coding-Standards
- **Plugin-API**: Integriert ordnungsgemäß mit WordPress-Plugin-Ökosystem

### Unterstützung & Wartung
- **Regelmäßige Updates**: Plugin wird aktiv gewartet und aktualisiert
- **Quellen-Überwachung**: Website-Änderungen werden verfolgt und Scraper aktualisiert
- **Community-Unterstützung**: Probleme und Funktionswünsche sind auf GitHub willkommen
- **Dokumentation**: Umfassende Dokumentation und Code-Kommentare

### Lizenz & Attribution
- **Lizenz**: GPL v2 oder später
- **Autor**: Ali Khaleghi
- **Repository**: https://github.com/AliKhaleghi/currencies-in-iran
- **Unterstützung**: Erstellen Sie Issues im GitHub-Repository

---

**Plugin-Version**: 0.1.6  
**Letzte Aktualisierung**: 8. Dezember 2025  
**WordPress-Version**: 6.0+  
**PHP-Version**: 7.4+