# افزونه نرخ روز ارز

یک افزونه وردپرس که نرخ‌های تبدیل ارز را به‌صورت لحظه‌ای از وب‌سایت‌های مالی ایرانی استخراج و نمایش می‌دهد.

## ویژگی‌ها

- **نرخ‌های لحظه‌ای**: استخراج خودکار نرخ‌های تبدیل دلار از چندین منبع ایرانی
- **منابع متعدد**: در حال حاضر پشتیبانی از:
  - [اقتصادنیوز](https://www.eghtesadnews.com/markets/dollar)
  - [دنیای اقتصاد](https://www.tgju.org/profile/price_dollar_rl)
- **پشتیبانی چندزبانه**: بین‌المللی‌سازی کامل با ترجمه‌های فارسی و آلمانی
- **سیستم کش**: استفاده از API Transients وردپرس برای کش کارآمد (پیش‌فرض ۱۵ دقیقه)
- **داشبورد مدیریت**: رابط مدیریتی جامع برای مشاهده نرخ‌ها و مدیریت تنظیمات
- **پشتیبانی از شورت‌کد**: نمایش نرخ‌ها در هر جای سایت با استفاده از شورت‌کدها
- **به‌روزرسانی خودکار**: یکپارچه‌سازی با WP-Cron برای به‌روزرسانی برنامه‌ریزی شده نرخ‌ها
- **مدیریت خطا**: ثبت خطا و اعتبارسنجی قوی
- **طراحی واکنش‌گرا**: نمایش رابط کاربری موبایل پسند
- **معماری گسترش‌پذیر**: افزودن آسان منابع و ارزهای جدید

## نیازمندی‌ها

- وردپرس 6.0+
- PHP 7.4+
- فعال بودن افزونه‌های DOM و cURL

## دستورالعمل نصب

### روش 1: مدیریت وردپرس (توصیه شده)
1. در مدیریت وردپرس، به **افزونه‌ها → افزودن → بارگذاری افزونه** بروید
2. روی **انتخاب فایل** کلیک کرده و فایل `currencies-in-iran.zip` را انتخاب کنید
3. روی **همین حالا نصب کن** کلیک کنید
4. روی **فعال‌سازی** کلیک کنید
5. تنظیمات را در **نرخ روز ارز → تنظیمات** پیکربندی کنید

### روش 2: FTP/SFTP دستی
1. فایل ZIP افزونه را دانلود و استخراج کنید
2. پوشه `currencies-in-iran` را در `/wp-content/plugins/` بارگذاری کنید
3. در مدیریت وردپرس، به **افزونه‌ها → افزونه‌های نصب شده** بروید
4. **نرخ روز ارز** را پیدا کرده و روی **فعال‌سازی** کلیک کنید
5. تنظیمات را در **نرخ روز ارز → تنظیمات** پیکربندی کنید

### روش 3: راه‌اندازی توسعه
1. مخزن را در `/wp-content/plugins/currencies-in-iran/` کلون کنید
2. از صحت مجوزهای فایل اطمینان حاصل کنید (755 برای پوشه‌ها، 644 برای فایل‌ها)
3. افزونه را در مدیریت وردپرس فعال کنید

## سوالات متداول

**س: نرخ‌ها چقدر often به‌روزرسانی می‌شوند؟**
پاسخ: نرخ‌ها هر ۱۵ دقیقه به‌صورت خودکار از طریق WP-Cron به‌روزرسانی می‌شوند. همچنین می‌توانید به‌صورت دستی از طریق داشبورد مدیریت تازه‌سازی کنید.

**س: آیا می‌توانم نرخ‌ها را در رابط کاربری نمایش دهم؟**
پاسخ: بله! از شورت‌کد `[currencies_in_iran]` در هر جای نوشته‌ها، صفحات یا ابزارک‌های خود استفاده کنید.

**س: کدام ارزها پشتیبانی می‌شوند؟**
پاسخ: در حال حاضر فقط USD (دلار آمریکا به ریال ایران) پشتیبانی می‌شود. ارزهای دیگر به راحتی قابل افزودن هستند.

**س: اگر وب‌سایت منبع از کار افتاد چه اتفاقی می‌افتد؟**
پاسخ: افزونه به کار خود با منابع موجود ادامه داده و هرگونه خطا را ثبت می‌کند. پیام‌های خطا را در داشبورد مدیریت مشاهده خواهید کرد.

**س: آیا می‌توانم قالب نمایش را سفارشی کنم؟**
پاسخ: بله! شورت‌کد گزینه‌های متعددی مانند `format="table"`, `show_average="true"`, و `sources="eghtesadnews,tgju"` را پشتیبانی می‌کند.

**س: آیا این افزونه برای سایت من امن است؟**
پاسخ: بله! این افزونه بهترین شیوه‌های امنیتی وردپرس را دنبال می‌کند، از پاک‌سازی مناسب داده استفاده می‌کند و شامل تأیید nonce است.

**س: چگونه می‌توانم یک منبع ارز جدید اضافه کنم؟**
پاسخ: یک فایل PHP جدید در `includes/sources/{currency}/` ایجاد کنید که `CurrencyInterface` را پیاده‌سازی کند. افزونه به‌صورت خودکار آن را تشخیص خواهد داد.

**س: آیا این افزونه سایت من را کند می‌کند؟**
پاسخ: خیر! نرخ‌ها به مدت ۱۵ دقیقه کش می‌شوند، بنابراین استخراج فقط به‌صورت دوره‌ای انجام می‌شود، نه در هر بار بارگذاری صفحه.

## تغییرات

### نسخه 0.1.6 (۸ دسامبر ۲۰۲۵)
- **افزوده**: پشتیبانی کامل بین‌المللی‌سازی با ترجمه‌های فارسی و آلمانی
- **ایجاد شده**: فایل‌های زبان کامل .po/.mo برای locales fa_IR و de_DE
- **به‌روزرسانی**: افزونه برای استفاده از بارگذاری استاندارد text domain وردپرس
- **بهبود**: رابط کاربری مدیریتی و نمایش چندزبانه
- **بهتر**: تجربه کاربری برای کاربران غیرانگلیسی زبان
- **استاندارد**: معماری آماده ترجمه پیروی بهترین شیوه‌های وردپرس

### نسخه 0.1.5 (۸ دسامبر ۲۰۲۵)
- **رفع**: اسکرپر اقتصادنیوز با سلکتورهای دقیق هدف‌گیری ساختار price-tables
- **بهبود**: الگوهای اقتصادنیوز برای استخراج سطر اصلی "دلار" (حذف انواع دیگر دلار)
- **افزوده**: تبدیل تومان به ریال برای اقتصادنیوز (۱ تومان = ۱۰ ریال)
- **بهبود**: الگوریتم امتیازدهی برای اولویت‌بخشی الگوهای دقیق ساختار جدول
- **به‌روزرسانی**: سلکتورها برای حذف "دلار کانادا"، "دلار در صرافی ملی"، و غیره
- **تست شده**: تأیید کار با داده‌های زنده استخراج نرخ صحیح (۱,۲۴۲,۵۰۰ ریال)
- **نتیجه**: هر دو اسکرپر اکنون با نرخ‌های سازگار در محدوده ۲,۰۰۰ ریال تفاوت کار می‌کنند

### نسخه 0.1.4 (۸ دسامبر ۲۰۲۵)
- **رفع**: عملکرد AJAX برای دکمه‌های تازه‌سازی و پاک کردن کش
- **رفع**: متدهای گمشده در کلاس CacheManager که باعث خطاهای مهلک می‌شد
- **بهبود**: اسکرپر دنیای اقتصاد با سلکتورهای هدف‌گیری "نرخ فعلی" (نرخ فعلی)
- **تقویت**: اعتبارسنجی نرخ برای محدوده‌های واقعی USD (1.1M-1.5M IRR)
- **افزوده**: حالت‌های بارگذاری جاوااسکریپت و اعلان‌های کاربری
- **افزوده**: مدیریت خطا و ثبت جامع
- **بازسازی**: انتقال CurrencyInterface به دایرکتوری منابع برای سازماندهی بهتر
- **افزوده**: سیستم اعتبارسنجی منبع با ثبت اشکال‌زدایی
- **بهبود**: داشبورد مدیریت با بازخورد بصری بهتر

### نسخه 0.1 (۸ دسامبر ۲۰۲۵)
- **انتشار اولیه**: استخراج نرخ پایه USD از اقتصادنیوز و دنیای اقتصاد
- **افزوده**: داشبورد مدیریت وردپرس برای مدیریت نرخ
- **افزوده**: سیستم شورت‌کد برای نمایش رابط کاربری
- **افزوده**: سیستم کش با انقضای ۱۵ دقیقه
- **افزوده**: یکپارچه‌سازی WP-Cron برای به‌روزرسانی‌های خودکار
- **افزوده**: ثبت خطا و اعتبارسنجی
- **افزوده**: استایل‌دهی واکنش‌گرا CSS برای مدیریت و رابط کاربری
- **افزوده**: معماری منبع گسترش‌پذیر با استفاده از اینترفیس‌ها

## اطلاعات اضافی

### معماری افزونه
افزونه از معماری ماژولار و گسترش‌پذیر استفاده می‌کند:

```
currencies-in-iran/
├── currencies-in-iran.php          # فایل اصلی افزونه
├── includes/
│   ├── sources/                    # پیاده‌سازی‌های منبع ارز
│   │   ├── CurrencyInterface.php   # قرارداد استاندارد برای تمام منابع
│   │   ├── class-source-loader.php # جلوگیری از تداخل و مدیریت بارگذاری
│   │   └── usd/                # منابع ارز USD
│   │       ├── eghtesadnews.php  # اسکرپر اقتصادنیوز
│   │       └── tgju.php         # اسکرپر دنیای اقتصاد
│   ├── class-admin.php            # داشبورد مدیریت
│   ├── class-cache-manager.php     # سیستم کش
│   ├── class-shortcode.php       # شورت‌کد رابط کاربری
│   └── class-source-manager.php   # مدیریت منبع
├── languages/                    # فایل‌های ترجمه
│   ├── currencies-in-iran-fa_IR.po # ترجمه فارسی
│   └── currencies-in-iran-de_DE.po # ترجمه آلمانی
└── assets/
    ├── css/                      # شیوه‌نامه‌ها
    └── js/                       # فایل‌های جاوااسکریپت
```

### منابع داده
- **اقتصادنیوز**: استخراج از https://www.eghtesadnews.com/markets/dollar
- **دنیای اقتصاد**: استخراج از https://www.tgju.org/profile/price_dollar_rl
- هر دو منبع نرخ‌های تبدیل USD به IRR (ریال ایران) را ارائه می‌دهند
- داده‌ها اعتبارسنجی و کش می‌شوند تا دقت و عملکرد تضمین شود

### ویژگی‌های امنیتی
- **تأیید Nonce**: تمام درخواست‌های AJAX شامل nonce وردپرس هستند
- **بررسی توانایی**: توابع مدیریت به توانایی `manage_options` نیاز دارند
- **پاک‌سازی داده**: تمام ورودی و خروجی کاربر به‌صورت مناسب فرار می‌شود
- **محدودیت نرخ**: به وب‌سایت‌های منبع با فاصله‌های درخواست مناسب احترام گذاشته می‌شود
- **ثبت خطا**: ثبت جامع بدون افشای اطلاعات حساس

### بهینه‌سازی‌های عملکرد
- **کش**: کش ۱۵ دقیقه‌ای بار سرور را کاهش می‌دهد
- **استخراج کارآمد**: استراتژی‌های استخراج متعدد با امتیازدهی
- **کوئری‌های حداقلی پایگاه داده**: استفاده کارآمد از گزینه‌ها و transients وردپرس
- **بارگذاری تنبل**: منابع فقط در صورت نیاز بارگذاری می‌شوند
- **دارایی‌های فشرده**: CSS و JS در تولید به‌صورت فشرده شده‌اند

## یادداشت‌های دیگر

### توسعه و گسترش‌پذیری
- **فضای نام**: تمام کدها از فضای نام `AliKhaleghi\CurrenciesInIran` استفاده می‌کنند
- **قلاب‌ها**: افزونهقلاب‌های وردپرس برای سفارشی‌سازی ارائه می‌دهد
- **فیلترها**: داده‌ها می‌توانند با استفاده از فیلترهای وردپرس تغییر کنند
- **اکشن‌ها**: رویدادها می‌توانند با استفاده از اکشن‌های وردپرس گسترش یابند
- **حالت اشکال‌زدایی**: فعال‌سازی `WP_DEBUG` برای مشاهده جزئیات ثبت اعتبارسنجی منبع

### سازگاری مرورگر
- **مرورگرهای مدرن**: پشتیبانی کامل برای کروم، فایرفاکس، سافاری، اج
- **واکنش‌گرا موبایل**: بهینه‌سازی برای تمام اندازه‌های صفحه
- **کاهش تدریجی**: کار بدون جاوااسکریپت (عملکرد پایه)
- **بهبود تدریجی**: ویژگی‌های تقویت شده با جاوااسکریپت فعال

### یکپارچه‌سازی وردپرس
- **سازگار چند سایتی**: کار روی نصب‌های چند سایتی وردپرس
- **آماده ترجمه**: استفاده از توابع i18n وردپرس
- **استانداردهای کدنویسی**: پیروی استانداردهای کدنویسی وردپرس
- **API افزونه**: یکپارچه‌سازی مناسب با اکوسیستم افزونه وردپرس

### پشتیبانی و نگهداری
- **به‌روزرسانی‌های منظم**: افزونه به‌صورت فعال نگهداری و به‌روزرسانی می‌شود
- **نظارت بر منبع**: تغییرات وب‌سایت‌ها ردیابی و اسکرپر به‌روزرسانی می‌شود
- **پشتیبانی جامعه**: مسائل و درخواست‌های ویژگی در گیت‌اب استقبال می‌شود
- **مستندات**: مستندات جامع و کامنت‌های کد

### مجوز و انتساب
- **مجوز**: GPL v2 یا بالاتر
- **نویسنده**: علی خالقی
- **مخزن**: https://github.com/AliKhaleghi/currencies-in-iran
- **پشتیبانی**: ایجاد مسائل در مخزن گیت‌اب

---

**نسخه افزونه**: 0.1.6  
**آخرین به‌روزرسانی**: ۸ دسامبر ۲۰۲۵  
**نسخه وردپرس**: 6.0+  
**نسخه PHP**: 7.4+