# Currencies in Iran Scraper Plugin

A WordPress plugin that scrapes and displays real-time currency exchange rates from Iranian financial websites.

## Features

- **Real-time Rates**: Automatically scrapes exchange rates from multiple Iranian sources
- **Multi-Currency Support**: Supports USD, EUR, GBP, SEK, and AED currencies
- **Multiple Sources**: Currently supports:
  - **USD**: [EghtesadNews](https://www.eghtesadnews.com/markets/dollar), [Tgju](https://www.tgju.org/profile/price_dollar_rl)
  - **EUR/GBP/SEK**: [Tgju](https://www.tgju.org) financial data platform
  - **AED**: [Alanchand](https://alanchand.com/currencies-price/aed)
- **Multi-language Support**: Full internationalization with Farsi and German translations
- **Caching System**: Uses WordPress Transients API for efficient caching (15-minute default)
- **Admin Dashboard**: Comprehensive admin interface to view rates, manage settings, and control sources
- **Display Format Options**: Choose between IRR (Rial) or IRT (Toman) display formats
- **Shortcode Support**: Display rates anywhere on your site using shortcodes
- **Automatic Updates**: WP-Cron integration for scheduled rate updates
- **Error Handling**: Robust error logging and validation
- **Responsive Design**: Mobile-friendly frontend display
- **Extensible Architecture**: Easy to add new sources and currencies

## Requirements

- WordPress 6.0+
- PHP 7.4+
- DOM and cURL extensions enabled

## Installation Instructions

### Method 1: WordPress Admin (Recommended)
1. In your WordPress admin, go to **Plugins → Add New → Upload Plugin**
2. Click **Choose File** and select the `currencies-in-iran.zip` file
3. Click **Install Now**
4. Click **Activate Plugin**
5. Configure settings in **Currencies in Iran → Settings**

### Method 2: Manual FTP/SFTP
1. Download the plugin ZIP file and extract it
2. Upload the `currencies-in-iran` folder to `/wp-content/plugins/`
3. In WordPress admin, go to **Plugins → Installed Plugins**
4. Find **Currencies in Iran** and click **Activate**
5. Configure settings in **Currencies in Iran → Settings**

### Method 3: Development Setup
1. Clone the repository to `/wp-content/plugins/currencies-in-iran/`
2. Ensure file permissions are correct (755 for directories, 644 for files)
3. Activate plugin in WordPress admin

## Frequently Asked Questions

**Q: How often are the rates updated?**
A: Rates are automatically updated every 15 minutes via WP-Cron. You can also manually refresh using the admin dashboard.

**Q: Can I display rates on the frontend?**
A: Yes! Use the shortcode `[currencies_in_iran]` anywhere in your posts, pages, or widgets.

**Q: Which currencies are supported?**
A: Currently supports USD, EUR, GBP, SEK, and AED (all to Iranian Rial). More currencies can be added easily by creating new source files.

**Q: What if a source website is down?**
A: The plugin will continue working with available sources and log any errors. You'll see error messages in the admin dashboard.

**Q: Can I customize the display format?**
A: Yes! You can choose between IRR (Iranian Rial) and IRT (Iranian Toman) display formats in the plugin settings. The shortcode also supports multiple options:

- `format="table"` - Display as table format
- `show_average="true"` - Include average rate from all sources  
- `sources="eghtesadnews,tgju"` - Show specific sources only
- `currency="EUR"` - Show specific currency (USD, EUR, GBP, SEK, AED)
- `decimal_places="2"` - Number of decimal places to display

**Example:** `[currencies_in_iran currency="EUR" format="table" decimal_places="2"]`

**Q: Is the plugin safe for my site?**
A: Yes! The plugin follows WordPress security best practices, uses proper data sanitization, and includes nonce verification.

**Q: How can I add a new currency source?**
A: Create a new PHP file in `includes/sources/{currency}/` that implements the `CurrencyInterface`. The plugin will auto-detect it. You can also enable/disable sources in the Sources admin page.

**Q: Can I disable specific sources?**
A: Yes! Go to **Currencies in Iran → Sources** in your admin dashboard. You can toggle on/off any source for each currency to customize which data providers to use.

**Q: What's the difference between IRR and IRT display formats?**
A: IRR shows prices in Iranian Rial (the official currency), while IRT shows prices in Iranian Toman (1 Toman = 10 Rial). The underlying data is always stored in IRR, but you can choose your preferred display format.

**Q: Does this plugin slow down my site?**
A: No! Rates are cached for 15 minutes, so scraping only happens periodically, not on every page load.

## Changelog

### Version 0.1.14 (December 8, 2025)
- **Added**: AED (UAE Dirham) currency support with Alanchand source
- **Added**: Sources management page to enable/disable individual currency sources
- **Improved**: Admin UI with modern grid layout for source management
- **Enhanced**: SourceManager with configurable source enabling/disabling
- **Separated**: Admin views into dedicated template files for better organization
- **Updated**: Documentation and shortcode examples to include AED currency

### Version 0.1.13 (December 8, 2025)
- **Enhanced**: Multi-currency extraction logic with unified "نرخ فعلی" targeting across all currencies
- **Improved**: EUR, GBP, SEK sources now use identical extraction logic as proven USD implementation
- **Optimized**: Currency-specific validation ranges for realistic market rates (EUR: 1.4M-1.6M IRR, GBP: 1.6M-1.8M IRR, SEK: 150K-180K IRR)
- **Validated**: All currency sources tested and confirmed working with proper interface compliance
- **Updated**: Comprehensive documentation with multi-currency usage examples and architecture details
- **Stabilized**: Production-ready plugin with complete internationalization and professional admin interface

### Version 0.1.12 (December 8, 2025)
- **Improved**: Admin menu structure with Settings moved to last position
- **Enhanced**: Shortcode documentation with new parameters (currency, decimal_places)
- **Added**: Comprehensive shortcode usage examples in admin interface
- **Updated**: Menu order for better user experience (Dashboard → Detailed → Settings)
- **Fixed**: All strings properly internationalized with WordPress i18n functions

### Version 0.1.11 (December 8, 2025)
- **Added**: Professional admin settings page with currency display format options
- **Enhanced**: Users can choose between IRR (Iranian Rial) and IRT (Iranian Toman) display formats
- **Improved**: Price formatting applied consistently across admin dashboard and shortcodes
- **Updated**: Helper functions for centralized currency format handling
- **Fixed**: EUR/GBP/SEK extraction to use USD logic with proper rate targeting

### Version 0.1.10 (December 8, 2025)
- **Added**: Multi-currency support for EUR, GBP, and SEK alongside existing USD
- **Enhanced**: SourceManager to load and manage multiple currency sources
- **Created**: New Tgju-based scrapers for EUR, GBP, and SEK currencies
- **Improved**: CacheManager with currency-specific validation ranges
- **Updated**: Admin interface to support multi-currency rate display
- **Extended**: Plugin architecture to handle multiple currencies seamlessly

### Version 0.1.9 (December 8, 2025)
- **Fixed**: Icon positioning in notifications and cache buttons with proper flexbox alignment
- **Fixed**: Cache dropdown positioning to prevent viewport overflow on mobile devices
- **Added**: Standalone detailed rates page as submenu with grid layout
- **Removed**: Detailed rates section from main dashboard for cleaner interface
- **Enhanced**: Navigation with quick action buttons between admin pages
- **Improved**: Mobile responsiveness for all UI elements
- **Added**: Available sources information section on detailed rates page

### Version 0.1.8 (December 8, 2025)
- **Redesigned**: Complete admin UI with modern table format and notification system
- **Fixed**: False error reporting by adjusting validation range (50K-3M IRR)
- **Added**: Notification modal with badge system for error management
- **Enhanced**: Cache status moved to dropdown in table header
- **Improved**: User experience with responsive design and better interactions
- **Implemented**: AJAX-powered error clearing functionality

### Version 0.1.7 (December 8, 2025)
- **Finalized**: Internationalization implementation with refined translations
- **Updated**: Documentation structure for better multi-language support
- **Enhanced**: Plugin readiness for international distribution
- **Stabilized**: Translation files and language loading mechanism

### Version 0.1.6 (December 8, 2025)
- **Added**: Full internationalization support with Farsi and German translations
- **Created**: Complete .po/.mo language files for fa_IR and de_DE locales
- **Updated**: Plugin to use WordPress standard text domain loading
- **Enhanced**: Multi-language admin interface and frontend display
- **Improved**: User experience for non-English speaking users
- **Standardized**: Translation-ready architecture following WordPress best practices

### Version 0.1.5 (December 8, 2025)
- **Fixed**: EghtesadNews scraper with precise selectors targeting price-tables structure
- **Enhanced**: EghtesadNews patterns to extract main "دلار" row (excluding other dollar types)
- **Added**: Toman to Rial conversion for EghtesadNews (1 Toman = 10 Rial)
- **Improved**: Scoring algorithm to prioritize exact table structure patterns
- **Updated**: Selectors to exclude "دلار کانادا", "دلار در صرافی ملی", etc.
- **Tested**: Confirmed working with live data extracting correct rate (1,242,500 IRR)
- **Result**: Both scrapers now working with consistent rates within 2,000 IRR difference

### Version 0.1.4 (December 8, 2025)
- **Fixed**: Critical scraping validation issues preventing rate extraction
- **Enhanced**: Tgju scraper with precise selectors targeting "نرخ فعلی" table row
- **Updated**: Rate validation ranges to accommodate current market rates (50K-3M IRR)
- **Improved**: Pattern matching for exact HTML structure from tgju.org
- **Optimized**: Scoring algorithm to prioritize "نرخ فعلی" patterns with highest priority
- **Tested**: Confirmed working with live data extracting correct rate (1,240,050 IRR)
- **Fixed**: Both scrapers now successfully extract and validate real market rates

### Version 0.1.1 (December 8, 2025)
- **Fixed**: AJAX functionality for refresh and clear cache buttons
- **Fixed**: Missing methods in CacheManager class causing fatal errors
- **Improved**: Tgju scraper with targeted selectors for "نرخ فعلی" (current rate)
- **Enhanced**: Rate validation for realistic USD ranges (1.1M-1.5M IRR)
- **Added**: JavaScript loading states and user notifications
- **Added**: Comprehensive error handling and logging
- **Restructured**: Moved CurrencyInterface to sources directory for better organization
- **Added**: Source validation system with debug logging
- **Improved**: Admin dashboard with better visual feedback

### Version 0.1 (December 8, 2025)
- **Initial release**: Basic USD rate scraping from EghtesadNews and Tgju
- **Added**: WordPress admin dashboard for rate management
- **Added**: Shortcode system for frontend display
- **Added**: Caching system with 15-minute expiry
- **Added**: WP-Cron integration for automatic updates
- **Added**: Error logging and validation
- **Added**: Responsive CSS styling for admin and frontend
- **Added**: Extensible source architecture using interfaces

## Additional Information

### Plugin Architecture
The plugin uses a modular, extensible architecture:

```
currencies-in-iran/
├── currencies-in-iran.php          # Main plugin file
├── includes/
│   ├── sources/                    # Currency source implementations
│   │   ├── CurrencyInterface.php   # Standard contract for all sources
│   │   ├── class-source-loader.php # Prevents conflicts and manages loading
│   │   ├── usd/                # USD currency sources
│   │   │   ├── eghtesadnews.php  # EghtesadNews scraper
│   │   │   └── tgju.php         # Tgju scraper
│   │   ├── eur/                # EUR currency sources
│   │   │   └── tgju.php         # Tgju EUR scraper
│   │   ├── gbp/                # GBP currency sources
│   │   │   └── tgju.php         # Tgju GBP scraper
│   │   ├── sek/                # SEK currency sources
│   │   │       └── tgju.php         # Tgju SEK scraper
│   │   └── aed/                # AED currency sources
│   │       └── alanchand.php    # Alanchand scraper
│   ├── views/                     # Admin view templates
│   │   └── sources.php            # Sources management page
│   ├── class-admin.php            # Admin dashboard
│   ├── class-cache-manager.php     # Caching system
│   ├── class-shortcode.php       # Frontend shortcode
│   └── class-source-manager.php   # Source management
└── assets/
    ├── css/                      # Stylesheets
    └── js/                       # JavaScript files
```

### Data Sources
- **EghtesadNews**: Scrapes USD rates from https://www.eghtesadnews.com/markets/dollar
- **Tgju**: Scrapes all supported currencies (USD, EUR, GBP, SEK) from https://www.tgju.org
- **Alanchand**: Scrapes AED rates from https://alanchand.com/currencies-price/aed
- All sources provide currency to IRR (Iranian Rial) exchange rates
- Data is validated with currency-specific ranges and cached to ensure accuracy and performance

### Security Features
- **Nonce Verification**: All AJAX requests include WordPress nonces
- **Capability Checks**: Admin functions require `manage_options` capability
- **Data Sanitization**: All user input and output is properly escaped
- **Rate Limiting**: Respects source websites with proper request intervals
- **Error Logging**: Comprehensive logging without exposing sensitive information

### Performance Optimizations
- **Caching**: 15-minute cache reduces server load
- **Efficient Scraping**: Multiple extraction strategies with scoring
- **Minimal Database Queries**: Uses WordPress options and transients efficiently
- **Lazy Loading**: Sources only loaded when needed
- **Compressed Assets**: CSS and JS are properly minified in production

## Other Notes

### Development & Extensibility
- **Namespace**: All code uses `AliKhaleghi\CurrenciesInIran` namespace
- **Hooks**: Plugin provides WordPress hooks for customization
- **Filters**: Data can be modified using WordPress filters
- **Actions**: Events can be extended using WordPress actions
- **Debug Mode**: Enable `WP_DEBUG` to see detailed source validation logs

### Browser Compatibility
- **Modern Browsers**: Full support for Chrome, Firefox, Safari, Edge
- **Mobile Responsive**: Optimized for all screen sizes
- **Graceful Degradation**: Works without JavaScript (basic functionality)
- **Progressive Enhancement**: Enhanced features with JavaScript enabled

### WordPress Integration
- **Multisite Compatible**: Works on WordPress multisite installations
- **Translation Ready**: Uses WordPress i18n functions
- **Coding Standards**: Follows WordPress coding standards
- **Plugin API**: Integrates properly with WordPress plugin ecosystem

### Support & Maintenance
- **Regular Updates**: Plugin is actively maintained and updated
- **Source Monitoring**: Website changes are tracked and scraper updated
- **Community Support**: Issues and feature requests welcome on GitHub
- **Documentation**: Comprehensive documentation and code comments

### License & Attribution
- **License**: GPL v2 or later
- **Author**: Ali Khaleghi
- **Repository**: https://github.com/AliKhaleghi/currencies-in-iran
- **Support**: Create issues on GitHub repository

---

**Plugin Version**: 0.1.14  
**Last Updated**: December 8, 2025  
**WordPress Version**: 6.0+  
**PHP Version**: 7.4+