jQuery(document).ready(function($) {
    'use strict';
    
    // Cache dropdown toggle
    $('#alikhalghi-cii-cache-toggle').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        var $dropdown = $('#alikhalghi-cii-cache-dropdown');
        $dropdown.toggle();
        
        // Close dropdown when clicking outside
        $(document).one('click', function() {
            $dropdown.hide();
        });
    });
    
    // Prevent dropdown from closing when clicking inside
    $('#alikhalghi-cii-cache-dropdown').on('click', function(e) {
        e.stopPropagation();
    });
    
    // Notifications modal
    $('#alikhalghi-cii-notifications-btn').on('click', function(e) {
        e.preventDefault();
        $('#alikhalghi-cii-notifications-modal').show();
    });
    
    // Close modal
    $('.alikhalghi-cii-modal-close').on('click', function() {
        $('#alikhalghi-cii-notifications-modal').hide();
    });
    
    // Close modal when clicking outside
    $(window).on('click', function(e) {
        if ($(e.target).hasClass('alikhalghi-cii-modal')) {
            $('.alikhalghi-cii-modal').hide();
        }
    });
    
    // Refresh rates button
    $('#alikhalghi-cii-refresh').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var originalText = $button.text();
        
        // Show loading state
        $button.prop('disabled', true)
               .text(alikhalghi_cii_admin.refresh_text)
               .addClass('loading');
        
        // Show loading overlay
        $('#alikhalghi-cii-loading').show();
        
        // AJAX request
        $.ajax({
            url: alikhalghi_cii_admin.ajax_url,
            type: 'POST',
            data: {
                action: 'alikhalghi_cii_refresh',
                nonce: alikhalghi_cii_admin.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Show success message
                    showNotification(alikhalghi_cii_admin.success_text, 'success');
                    
                    // Reload page after short delay to show updated data
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    // Show error message
                    showNotification(response.data.message || alikhalghi_cii_admin.error_text, 'error');
                }
            },
            error: function(xhr, status, error) {
                // Show error message
                showNotification(alikhalghi_cii_admin.error_text + ': ' + error, 'error');
            },
            complete: function() {
                // Reset button state
                $button.prop('disabled', false)
                       .text(originalText)
                       .removeClass('loading');
                
                // Hide loading overlay
                $('#alikhalghi-cii-loading').hide();
            }
        });
    });
    
    // Clear cache button
    $('#alikhalghi-cii-clear-cache').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var originalText = $button.text();
        
        // Show loading state
        $button.prop('disabled', true)
               .text(alikhalghi_cii_admin.clear_text)
               .addClass('loading');
        
        // Show loading overlay
        $('#alikhalghi-cii-loading').show();
        
        // AJAX request
        $.ajax({
            url: alikhalghi_cii_admin.ajax_url,
            type: 'POST',
            data: {
                action: 'alikhalghi_cii_clear_cache',
                nonce: alikhalghi_cii_admin.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Show success message
                    showNotification(alikhalghi_cii_admin.success_text, 'success');
                    
                    // Reload page after short delay to show updated data
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    // Show error message
                    showNotification(response.data.message || alikhalghi_cii_admin.error_text, 'error');
                }
            },
            error: function(xhr, status, error) {
                // Show error message
                showNotification(alikhalghi_cii_admin.error_text + ': ' + error, 'error');
            },
            complete: function() {
                // Reset button state
                $button.prop('disabled', false)
                       .text(originalText)
                       .removeClass('loading');
                
                // Hide loading overlay
                $('#alikhalghi-cii-loading').hide();
            }
        });
    });
    
    // Clear errors button
    $('#alikhalghi-cii-clear-errors').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var originalText = $button.text();
        
        // Show loading state
        $button.prop('disabled', true)
               .text(alikhalghi_cii_admin.clear_errors_text)
               .addClass('loading');
        
        // AJAX request
        $.ajax({
            url: alikhalghi_cii_admin.ajax_url,
            type: 'POST',
            data: {
                action: 'alikhalghi_cii_clear_errors',
                nonce: alikhalghi_cii_admin.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Show success message
                    showNotification(alikhalghi_cii_admin.success_text, 'success');
                    
                    // Reload page after short delay to show updated data
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    // Show error message
                    showNotification(response.data.message || alikhalghi_cii_admin.error_text, 'error');
                }
            },
            error: function(xhr, status, error) {
                // Show error message
                showNotification(alikhalghi_cii_admin.error_text + ': ' + error, 'error');
            },
            complete: function() {
                // Reset button state
                $button.prop('disabled', false)
                       .text(originalText)
                       .removeClass('loading');
            }
        });
    });
    
    // Notification function
    function showNotification(message, type) {
        type = type || 'info';
        
        // Create notification element
        var $notification = $('<div class="notice notice-' + type + ' is-dismissible">' +
            '<p>' + message + '</p>' +
            '<button type="button" class="notice-dismiss">' +
            '<span class="screen-reader-text">Dismiss this notice.</span>' +
            '</button>' +
            '</div>');
        
        // Add to top of admin page
        $('.wrap h1').after($notification);
        
        // Auto-dismiss after 5 seconds
        setTimeout(function() {
            $notification.fadeOut(500, function() {
                $(this).remove();
            });
        }, 5000);
        
        // Manual dismiss
        $notification.find('.notice-dismiss').on('click', function() {
            $notification.fadeOut(500, function() {
                $(this).remove();
            });
        });
    }
    
    // Add loading styles to buttons
    $('<style>').text([
        '.loading {',
        '    position: relative;',
        '    padding-left: 30px !important;',
        '}',
        '.loading:before {',
        '    content: "";',
        '    position: absolute;',
        '    left: 10px;',
        '    top: 50%;',
        '    transform: translateY(-50%);',
        '    width: 16px;',
        '    height: 16px;',
        '    border: 2px solid #f3f3f3f;',
        '    border-top: 2px solid #0073aa;',
        '    border-radius: 50%;',
        '    animation: spin 1s linear infinite;',
        '}',
        '@keyframes spin {',
        '    0% { transform: translateY(-50%) rotate(0deg); }',
        '    100% { transform: translateY(-50%) rotate(360deg); }',
        '}'
    ].join('')).appendTo('head');
});