<?php
/**
 * Plugin Name:  نرخ روز ارز
 * Plugin URI: https://github.com/AliKhaleghi/currencies-in-iran
 * Description: نرخ‌های تبدیل ارز را به‌صورت لحظه‌ای از وب‌سایت‌های مالی ایرانی استخراج و نمایش می‌دهد
 * Version: 0.1.13
 * Author: Ali Khaleghi
 * Author URI: https://github.com/AliKhaleghi
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: currencies-in-iran
 * Domain Path: /languages
 * Requires at least: 6.0
 * Requires PHP: 7.4
 * Network: false
 */

namespace AliKhaleghi\CurrenciesInIran;

if (!defined('ABSPATH')) {
    exit;
}

define('ALIKHALEGHI_CII_VERSION', '0.1.5');
define('ALIKHALEGHI_CII_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('ALIKHALEGHI_CII_PLUGIN_URL', plugin_dir_url(__FILE__));
define('ALIKHALEGHI_CII_CACHE_EXPIRY', 15 * MINUTE_IN_SECONDS);

class CurrenciesInIran {

    private static $instance = null;

    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action('plugins_loaded', [$this, 'init']);
        register_activation_hook(__FILE__, [$this, 'activate']);
        register_deactivation_hook(__FILE__, [$this, 'deactivate']);
    }

    public function init() {
        $this->load_textdomain();
        $this->load_dependencies();
        $this->init_classes();
        $this->setup_hooks();
    }

    private function load_textdomain() {
        load_plugin_textdomain(
            'currencies-in-iran',
            false,
            dirname(plugin_basename(__FILE__)) . '/languages/'
        );
    }

    private function load_dependencies() {
        require_once ALIKHALEGHI_CII_PLUGIN_DIR . 'includes/class-source-manager.php';
        require_once ALIKHALEGHI_CII_PLUGIN_DIR . 'includes/class-cache-manager.php';
        require_once ALIKHALEGHI_CII_PLUGIN_DIR . 'includes/class-admin.php';
        require_once ALIKHALEGHI_CII_PLUGIN_DIR . 'includes/class-shortcode.php';
    }

    private function init_classes() {
        \AliKhaleghi\CurrenciesInIran\Sources\SourceManager::get_instance();
        \AliKhaleghi\CurrenciesInIran\CacheManager::get_instance();
        \AliKhaleghi\CurrenciesInIran\Admin::get_instance();
        \AliKhaleghi\CurrenciesInIran\Shortcode::get_instance();
    }

    private function setup_hooks() {
        add_action('wp_enqueue_scripts', [$this, 'enqueue_frontend_scripts']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_scripts']);

        add_action('init', [$this, 'schedule_cron']);
        add_action('alikhalghi_cii_update_rates', [$this, 'update_all_rates']);
    }

    public function enqueue_frontend_scripts() {
        wp_enqueue_style(
            'alikhalghi-cii-frontend',
            ALIKHALEGHI_CII_PLUGIN_URL . 'assets/css/frontend.css',
            [],
            ALIKHALEGHI_CII_VERSION
        );
    }

    public function enqueue_admin_scripts($hook) {
        if ('toplevel_page_currencies-in-iran' === $hook) {
            wp_enqueue_style(
                'alikhalghi-cii-admin',
                ALIKHALEGHI_CII_PLUGIN_URL . 'assets/css/admin.css',
                [],
                ALIKHALEGHI_CII_VERSION
            );
        }
    }

    public function schedule_cron() {
        if (!wp_next_scheduled('alikhalghi_cii_update_rates')) {
            wp_schedule_event(time(), 'fifteen_minutes', 'alikhalghi_cii_update_rates');
        }
    }

    public function update_all_rates() {
        $source_manager = \AliKhaleghi\CurrenciesInIran\Sources\SourceManager::get_instance();
        $cache_manager = \AliKhaleghi\CurrenciesInIran\CacheManager::get_instance();

        $rates = $source_manager->get_all_rates();
        $cache_manager->set_rates($rates);

        if (empty($rates)) {
            error_log('Currencies in Iran: Failed to update rates - no data returned');
        }
    }

    public function activate() {
        $this->schedule_cron();
        flush_rewrite_rules();
    }

    public function deactivate() {
        wp_clear_scheduled_hook('alikhalghi_cii_update_rates');
        flush_rewrite_rules();
    }
}

CurrenciesInIran::get_instance();
