<?php
namespace AliKhaleghi\CurrenciesInIran\Sources;

if (!defined('ABSPATH')) {
    exit;
}

interface CurrencyInterface {
    
    /**
     * Get currency code (e.g., 'USD')
     * 
     * @return string
     */
    public function get_currency_code();
    
    /**
     * Get source name (e.g., 'EghtesadNews')
     * 
     * @return string
     */
    public function get_source_name();
    
    /**
     * Get source URL
     * 
     * @return string
     */
    public function get_source_url();
    
    /**
     * Scrape current rate from source
     * 
     * @return array|WP_Error
     */
    public function scrape_rate();
    
    /**
     * Validate if extracted rate is reasonable
     * 
     * @param float $rate
     * @return bool
     */
    public function validate_rate($rate);
    
    /**
     * Get user agent for HTTP requests
     * 
     * @return string
     */
    public function get_user_agent();
    
    /**
     * Get request headers for HTTP requests
     * 
     * @return array
     */
    public function get_request_headers();
    
    /**
     * Get timeout for HTTP requests
     * 
     * @return int
     */
    public function get_timeout();
    
    /**
     * Format rate data for storage
     * 
     * @param float $rate
     * @param string $timestamp
     * @return array
     */
    public function format_rate_data($rate, $timestamp);
}