<?php
namespace AliKhaleghi\CurrenciesInIran\Sources;

if (!defined('ABSPATH')) {
    exit;
}

class SourceLoader {
    
    private static $loaded_interfaces = [];
    private static $loaded_sources = [];
    
    public static function load_interface() {
        $interface_file = ALIKHALEGHI_CII_PLUGIN_DIR . 'includes/sources/CurrencyInterface.php';
        
        if (!isset(self::$loaded_interfaces['CurrencyInterface'])) {
            if (file_exists($interface_file)) {
                require_once $interface_file;
                self::$loaded_interfaces['CurrencyInterface'] = true;
                return true;
            }
        }
        
        return false;
    }
    
    public static function load_source($currency, $slug, $class_name) {
        $source_key = "{$currency}_{$slug}";
        
        if (isset(self::$loaded_sources[$source_key])) {
            return true;
        }
        
        $source_file = ALIKHALEGHI_CII_PLUGIN_DIR . "includes/sources/{$currency}/{$slug}.php";
        
        if (file_exists($source_file)) {
            require_once $source_file;
            self::$loaded_sources[$source_key] = true;
            return true;
        }
        
        return false;
    }
    
    public static function is_interface_loaded() {
        return isset(self::$loaded_interfaces['CurrencyInterface']);
    }
    
    public static function is_source_loaded($currency, $slug) {
        $source_key = "{$currency}_{$slug}";
        return isset(self::$loaded_sources[$source_key]);
    }
    
    public static function get_loaded_sources() {
        return array_keys(self::$loaded_sources);
    }
}