<?php
namespace AliKhaleghi\CurrenciesInIran\Sources;

if (!defined('ABSPATH')) {
    exit;
}

class SourceValidator {
    
    public static function validate_all_sources() {
        $results = [];
        
        // Test interface loading
        $interface_loaded = SourceLoader::is_interface_loaded();
        $results['interface_loaded'] = $interface_loaded;
        
        // Test USD sources
        $usd_sources = ['eghtesadnews', 'tgju'];
        $results['usd_sources'] = [];
        
        foreach ($usd_sources as $slug) {
            $source_loaded = SourceLoader::is_source_loaded('usd', $slug);
            $results['usd_sources'][$slug] = $source_loaded;
            
            if ($source_loaded) {
                $class = "AliKhaleghi\\CurrenciesInIran\\Sources\\USD\\" . ucfirst($slug);
                if ($slug === 'eghtesadnews') {
                    $class = "AliKhaleghi\\CurrenciesInIran\\Sources\\USD\\EghtesadNews";
                }
                
                if (class_exists($class)) {
                    $source = new $class();
                    $results['usd_sources'][$slug . '_implements_interface'] = $source instanceof CurrencyInterface;
                    $results['usd_sources'][$slug . '_currency'] = $source->get_currency_code();
                    $results['usd_sources'][$slug . '_source_name'] = $source->get_source_name();
                } else {
                    $results['usd_sources'][$slug . '_class_exists'] = false;
                }
            }
        }
        
        return $results;
    }
    
    public static function log_validation_results() {
        $results = self::validate_all_sources();
        
        error_log('Currencies in Iran - Source Validation Results:');
        error_log('Interface Loaded: ' . ($results['interface_loaded'] ? 'YES' : 'NO'));
        
        foreach ($results['usd_sources'] as $key => $value) {
            error_log("USD Source {$key}: " . (is_bool($value) ? ($value ? 'YES' : 'NO') : $value));
        }
        
        return $results;
    }
}