<?php
// Scan for all available source files
$available_sources = [];
$source_dir = ALIKHALEGHI_CII_PLUGIN_DIR . 'includes/sources/';

if (is_dir($source_dir)) {
    $dirs = glob($source_dir . '*', GLOB_ONLYDIR);
    foreach ($dirs as $dir) {
        $currency = strtoupper(basename($dir));
        $files = glob($dir . '/*.php');
        foreach ($files as $file) {
            $slug = basename($file, '.php');
            $name = ucfirst($slug);
            $available_sources[$currency][$slug] = $name;
        }
    }
}

// Get enabled sources from option
$enabled_sources = get_option('alikhalghi_cii_enabled_sources', []);

// Default all enabled if not set
if (empty($enabled_sources)) {
    foreach ($available_sources as $currency => $sources) {
        foreach ($sources as $source => $name) {
            $enabled_sources[$currency][$source] = true;
        }
    }
}

// Handle form submission
if (isset($_POST['submit_sources'])) {
    check_admin_referer('alikhalghi_cii_sources_nonce');

    $new_enabled = [];
    foreach ($available_sources as $currency => $sources) {
        foreach ($sources as $source => $name) {
            $key = "enable_{$currency}_{$source}";
            $new_enabled[$currency][$source] = isset($_POST[$key]);
        }
    }
    update_option('alikhalghi_cii_enabled_sources', $new_enabled);
    $enabled_sources = $new_enabled;

    echo '<div class="notice notice-success"><p>' . __('Sources updated successfully.', 'currencies-in-iran') . '</p></div>';
}
?>

<style>
.alikhalghi-cii-sources-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

@media screen and (max-width: 768px) {
    .alikhalghi-cii-sources-grid {
        grid-template-columns: 1fr;
    }
}

.alikhalghi-cii-currency-card {
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
    padding: 20px;
    box-shadow: 0 1px 1px rgba(0, 0, 0, 0.04);
}

.alikhalghi-cii-currency-card h3 {
    margin-top: 0;
    margin-bottom: 15px;
    font-size: 16px;
    font-weight: 600;
    color: #1e1e1e;
    text-align: center;
    border-bottom: 1px solid #eee;
    padding-bottom: 10px;
}

.alikhalghi-cii-sources-list {
    display: flex;
    flex-direction: column;
    gap: 15px;
}

.alikhalghi-cii-source-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px;
    background: #f8f9f9;
    border-radius: 6px;
    border: 1px solid #e0e0e0;
}

.alikhalghi-cii-source-name {
    flex: 1;
    font-size: 14px;
    font-weight: 500;
    color: #1e1e1e;
}

.alikhalghi-cii-switch {
    position: relative;
    display: inline-block;
    width: 50px;
    height: 24px;
}

.alikhalghi-cii-switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.alikhalghi-cii-slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: .4s;
    border-radius: 24px;
}

.alikhalghi-cii-slider:before {
    position: absolute;
    content: "";
    height: 18px;
    width: 18px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

input:checked + .alikhalghi-cii-slider {
    background-color: #0073aa;
}

input:checked + .alikhalghi-cii-slider:before {
    transform: translateX(26px);
}
</style>

<div class="wrap">
    <h1><?php _e('Currency Sources', 'currencies-in-iran'); ?></h1>
    <p><?php _e('Enable or disable sources for each currency. Disabled sources will not be used for rate calculations.', 'currencies-in-iran'); ?></p>

    <form method="post" action="">
        <?php wp_nonce_field('alikhalghi_cii_sources_nonce'); ?>

        <div class="alikhalghi-cii-sources-grid">
            <?php foreach ($available_sources as $currency => $sources): ?>
                <div class="alikhalghi-cii-currency-card">
                    <h3><?php echo esc_html($currency); ?></h3>
                    <div class="alikhalghi-cii-sources-list">
                        <?php foreach ($sources as $source => $name): ?>
                            <div class="alikhalghi-cii-source-item">
                                <span class="alikhalghi-cii-source-name"><?php echo esc_html($name); ?></span>
                                <label class="alikhalghi-cii-switch">
                                    <input type="checkbox"
                                           name="enable_<?php echo esc_attr($currency); ?>_<?php echo esc_attr($source); ?>"
                                           <?php checked(isset($enabled_sources[$currency][$source]) && $enabled_sources[$currency][$source]); ?>>
                                    <span class="alikhalghi-cii-slider"></span>
                                </label>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <p class="submit">
            <input type="submit" name="submit_sources" class="button button-primary" value="<?php _e('Save Changes', 'currencies-in-iran'); ?>">
        </p>
    </form>
</div>