jQuery(document).ready(function($) {
    $('.rsm-test-connection').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var storageId = $button.data('id');
        
        if (!storageId) {
            alert('Storage ID not found');
            return;
        }
        
        $button.prop('disabled', true).text('Testing...');
        
        $.post(ajaxurl, {
            action: 'rsm_test_connection',
            storage_id: storageId,
            nonce: rsm_admin.nonce
        }, function(response) {
            if (response.success) {
                alert('Connection successful: ' + response.data.message);
            } else {
                alert('Connection failed: ' + (response.data.message || 'Unknown error'));
            }
        }).fail(function() {
            alert('Connection test failed. Please check your settings.');
        }).always(function() {
            $button.prop('disabled', false).text('Test Connection');
        });
    });
    
    $('.rsm-toggle-advanced').on('click', function(e) {
        e.preventDefault();
        $('.rsm-advanced-settings').toggle();
    });
});