# **📌 PRODUCT REQUIREMENTS DOCUMENT (PRD)**

# **Remote Media Storage**

*(English Version)*

---

# **1. Product Summary**

Remote Media Storage is a WordPress plugin that enables site owners to store, manage, and serve media files (images, videos, documents) from **external storage spaces** such as FTP, FTPS, and SFTP servers, instead of their local WordPress hosting.

The plugin acts as a drop-in replacement for WordPress’s media storage, but with:

* multiple external storage spaces
* remote uploads
* URL rewriting
* migration tools
* backup tools (Pro)
* queue-based safe uploads

It integrates directly into the Media Library and behaves as if media is stored locally, while actually using external disk space.

---

# **2. Goals**

### **Primary Goals**

* Reduce hosting storage usage.
* Improve media performance by using external storage servers.
* Allow future monetization by letting you sell storage plans later.
* Provide a clean, extendable storage abstraction layer.

### **Secondary Goals**

* Improve media reliability.
* Enable multi-server distribution of storage.
* Let users manage remote media easily inside WP.

---

# **3. Non-Goals**

* Not a CDN system (though compatible with CDNs).
* Not limited to selling storage (future expansion).
* Not replacing WordPress’s entire media infrastructure (extends it).

---

# **4. Key Concepts**

### **Storage Space**

A storage space is:

* A configured remote server (FTP/SFTP/FTPS)
* With authentication
* A root path
* A public base URL
* A status indicator
  Users may add multiple storage spaces (Pro only).

### **File Pipeline / Upload Queue**

All remote operations (especially migrations) go into a queue:

* Prevents concurrency problems
* Allows retries
* Shows progress

---

# **5. Features**

---

# **5.1 Free Version Features**

### **1) One Storage Space**

User can configure one remote storage server:

* FTP / FTPS / SFTP supported

### **2) Upload to Remote Storage**

New uploads go directly to the configured storage:

* Originals
* Thumbnails

### **3) URL Rewriting**

Media URLs =
`{storage_public_url}/{path}/{filename}`

### **4) Basic Migration Tool**

Move existing `wp-content/uploads` files to remote storage.

### **5) Storage Space Tests**

* Connect test
* Write test
* Delete test
* URL test

### **6) WordPress Gallery Compatibility**

* Show remote files in media browser
* Search loads from WP database, NOT from remote FTP
* Dropdown to filter by storage space (only one in free)

### **7) Delete/Replace Sync**

When file deleted in WP → delete from remote storage.
When file replaced → replace remotely.

### **8) Basic Queue System**

Used during migrations.

---

# **5.2 Pro Version Features**

### **1) Multiple Storage Spaces**

Add unlimited FTP/SFTP/FTPS servers.

### **2) Disable Local Media**

Force all uploads to external storage only.

### **3) Scheduled Backups**

* Backup each storage space
* Send via email
* Or downloadable on demand

### **4) Storage Health Monitoring**

* Storage used
* Storage free
* Alert thresholds

### **5) URL Rebuild Tool**

If user changes:

* public URL
* folder structure
  → automatically update all media links in WP.

### **6) Local Thumbnail Cache**

Small thumbnails stored locally for speed.

### **7) Advanced File Actions**

* Rename
* Replace file
* Move between folders
* Move between storage spaces

### **8) Multi-Site Support**

Per-site isolation or shared settings.

### **9) Audit Log**

Logs:

* upload
* delete
* replace
* migration
* errors

---

# **6. Architecture**

---

# **6.1 Plugin Structure**

```
/remote-media-storage
    /includes
        StorageSpace.php
        StorageDriverInterface.php
        DriverFTP.php
        DriverSFTP.php
        FilePipeline.php
        MigrationManager.php
        UrlManager.php
        BackupManager.php
        MediaLibraryIntegration.php
    /assets
    /admin
    remote-media-storage.php
```

---

# **6.2 Custom Database Tables**

### **1) rsm_storage_spaces**

Stores configuration of each storage.

Fields:

* id
* name
* type (ftp/sftp/ftps)
* host
* port
* username
* encrypted password
* root_path
* public_url
* status (active/inactive/error)
* created_at

### **2) rsm_file_index**

Tracks every remote file.

Fields:

* id
* wp_attachment_id
* storage_space_id
* relative_path
* full_url
* file_size
* checksum
* created_at

### **3) rsm_queue**

For migration and upload pipeline.

Fields:

* id
* action (upload/delete/replace/migrate)
* storage_space_id
* wp_attachment_id
* status (pending/done/error)
* error_message
* created_at

### **4) rsm_logs** (Pro)

Audit logs.

---

# **7. Functional Flow**

---

# **7.1 Upload Flow**

1. User uploads image in WP Media Library.
2. Plugin intercepts upload.
3. Image saved temporarily locally.
4. Thumbnails generated.
5. File + thumbnails pushed to selected storage space via driver.
6. File metadata saved in `rsm_file_index`.
7. Local file removed (optional if Pro disabled-local-storage).

---

# **7.2 Migration Flow**

1. Admin selects migration tool.
2. All local uploads scanned.
3. Each file added to the queue.
4. Pipeline handles:

   * Upload to remote
   * Update URLs
   * Remove local file (if user chooses)
5. Progress bar shows real-time state.

---

# **7.3 Delete Flow**

1. When attachment is deleted:

   * Delete remote file
   * Delete thumbnails
   * Remove DB index

---

# **7.4 Public URL Update Flow**

When user changes public URL:

* System scans all attachments for that storage space
* Rewrites URL using new public URL
* Does NOT modify relative path

---

# **8. Admin UI**

### **Sections**

* Storage Spaces
* Add New Storage
* Media Settings
* Migration Tool
* Backups (Pro)
* Logs (Pro)
* Status Monitor

---

# **9. Extensibility**

Drivers can be added later:

* S3
* WebDAV
* Local server
* Google Drive
* OneDrive
* R2 Cloudflare

The plugin architecture supports future expansion.

---

# **10. Risks**

* FTP performance on shared servers
* Timeout during large migrations
* Users misconfiguring public URLs
* Cheap Iranian hosts blocking passive FTP

Mitigation:

* Queue system
* Timeout retries
* Connection testers
* Logs

---

# **11. Monetization**

Pro features create clear upsell:

* multi-storage
* local thumbnail cache
* backups
* multisite
* logs
* advanced file actions
* disable local media
* URL rebuild tool

---

# **12. Future Plans**

* Launch your own storage service
* Automatic provisioning from plugin
* Subscription integration
* CDN accelerator
* WordPress.com-style integration

---
