<?php
namespace AliKhaleghi\RemoteMediaStorage\Drivers;

interface StorageDriverInterface {
    public function connect(): bool;
    public function disconnect(): void;
    public function testConnection(): array;
    public function uploadFile(string $localPath, string $remotePath): bool;
    public function deleteFile(string $remotePath): bool;
    public function fileExists(string $remotePath): bool;
    public function getFileSize(string $remotePath): int;
    public function createDirectory(string $path): bool;
    public function listFiles(string $directory): array;
    public function getPermissions(string $path): string;
}