<?php
/**
 * Simple test script to verify plugin functionality
 * Run this in WordPress admin or CLI to test
 */

// Include WordPress
if (!defined('ABSPATH')) {
    $wp_base = dirname(__FILE__, 2);
    while (!file_exists($wp_base . '/wp-config.php') && $wp_base !== '/') {
        $wp_base = dirname($wp_base);
    }
    require_once($wp_base . '/wp-config.php');
}

// Test plugin activation
echo "Testing Remote Media Storage Plugin v0.0.1\n";

// Check if tables exist
global $wpdb;

$tables = [
    $wpdb->prefix . 'rsm_storage_spaces',
    $wpdb->prefix . 'rsm_file_index', 
    $wpdb->prefix . 'rsm_queue'
];

echo "Checking database tables:\n";
foreach ($tables as $table) {
    $result = $wpdb->get_var("SHOW TABLES LIKE '$table'");
    echo "- $table: " . ($result ? "✓ EXISTS" : "✗ MISSING") . "\n";
}

// Test FTP driver
echo "\nTesting FTP driver:\n";
try {
    $config = [
        'host' => 'test.rebex.net',
        'port' => 21,
        'username' => 'demo',
        'password' => 'password',
        'timeout' => 10
    ];
    
    $ftp = new \AliKhaleghi\RemoteMediaStorage\Drivers\FTP($config);
    $test = $ftp->testConnection();
    
    echo "- Connection test: " . ($test['success'] ? "✓ SUCCESS" : "✗ FAILED") . "\n";
    echo "- Message: " . $test['message'] . "\n";
} catch (Exception $e) {
    echo "- FTP driver test: ✗ EXCEPTION - " . $e->getMessage() . "\n";
}

// Test admin interface
echo "\nTesting admin interface:\n";
if (class_exists('\AliKhaleghi\RemoteMediaStorage\Admin\AdminInterface')) {
    echo "- AdminInterface class: ✓ EXISTS\n";
} else {
    echo "- AdminInterface class: ✗ MISSING\n";
}

// Test WordPress hooks
echo "\nTesting WordPress hooks:\n";
if (class_exists('\AliKhaleghi\RemoteMediaStorage\Integration\WordPressHooks')) {
    echo "- WordPressHooks class: ✓ EXISTS\n";
} else {
    echo "- WordPressHooks class: ✗ MISSING\n";
}

echo "\nPlugin test complete!\n";