<?php
/**
 * RSS Importer / Admin Related
 * Version: 1.0
 * Description: این افوزنه اسانس اهور است، تمامی پروژه های به من متصل میشوند.
 * Author: علی خالقی <awli.khaleghi@gmail.com>
 * Author URI: https://blog.ahur.ir
 * Plugin URI:  https://blog.ahur.ir
 */

include_once RSS_IMPORTER_DIR_PATH."Include/WPTables/NewsTable.php";
include_once RSS_IMPORTER_DIR_PATH."Include/WPTables/FeedTable.php";

if ( ! class_exists( 'RSSImporterAdmin' ) ) {
    class RSSImporterAdmin {
        /**
         * @var \FeedTable
         */
        private $feedsTable;
        
        /**
         * Constructor
         */
        public function __construct() {
            $this->feedsTable = new \FeedTable();

            //
            $this->setup_admin();
        }

        // -----------------------------------------------

        /**
         * Setting up Hooks
         */
        public function setup_admin() {

            add_action( 'admin_bar_menu', [$this, 'admin_top_menu'],999 );

            $pendingNews = get_option("rssimporter_news_count") ?:0 ;
            // Register Admin Menu
            $hook = add_menu_page(
                'لیست درخواست ها',
                "بازنشر اخبار <span class='update-plugins count-1' title='title'><span class='update-count'>$pendingNews</span></span>",
                'manage_options',
                'rssimporter',
                [$this,'RSSImporterView'],
                'dashicons-rest-api',
                28
            );
            $activeFeeds = get_option("rssimporter_active_feed_count") ?:0 ;
            $feedsMenu = add_submenu_page(
                'rssimporter',               // parent slug
                'لیست خبرگذاری ها',                // page title
                "لیست خبرگذاری ها <span class='update-plugins count-1' title='title'><span class='update-count'>$activeFeeds</span></span>",                // menu title
                'manage_options',                   // capability
                'rssimporter-feeds',  // slug
                [$this,'FeedsTableView'], // callback
            );

            $settingsMenu = add_submenu_page(
                'rssimporter',               // parent slug
                'تنظیمات',                // page title
                'تنظیمات',                // menu title
                'manage_options',                   // capability
                'rssimporter-setting',  // slug
                [$this,'SettingsView'] // callback
            );

            add_action( "load-$hook", [ $this, 'screen_option' ] );

            //--------------------------------------------------------------------
            $RSSImporterPageSuffix = [

                'news'  => $hook,
                'feeds'  => $feedsMenu,
                'settings'  => $settingsMenu,

            ];

            /**
             *  Queue Admin Scripts
             *
             *  @param string $hook
             *  @use $RSSImporterPageSuffix
             *  @return NULL
             */
            $fn = function ($hook) use($RSSImporterPageSuffix) {


                wp_enqueue_script( 'ajax-script', plugins_url( 'rssimporter/resources/base.js'), array('jquery') );
                wp_enqueue_style( 'style', plugins_url( 'rssimporter/resources/base.css'), array(), '1.1', 'all');

                wp_localize_script( 'ajax-script', 'rssimo', array(
                    'ajax_url' => admin_url( 'admin-ajax.php' ),
                    'nonce' => wp_create_nonce('ajax-nonce'),
                ) );

                wp_localize_script( 'ajax-script', 'rssimporter_ajax', array(
                    'nonce' => wp_create_nonce('rssimporter_status'),
                ) );

                if (!in_array($hook, $RSSImporterPageSuffix)) {
                    return;
                }
                wp_enqueue_style( 'semanticstyles', plugins_url( 'rssimporter/resources/semantic/semantic.min.css'), array(), '1.1', 'all');

                wp_enqueue_script( 'semanticscript2', plugins_url( 'rssimporter/resources/semantic/semantic.min.js'), array ( 'jquery' ));
                wp_enqueue_style( 'persiandatecss', plugins_url( 'rssimporter/resources/persiandate/css/persian-datepicker.min.css'), array(), '1.1', 'all');

                wp_enqueue_script( 'persiandate', plugins_url( 'rssimporter/resources/persiandate/js/persian-datepicker.js'), array ( 'jquery' ));


            };
            // custom css and js
            add_action('admin_enqueue_scripts', $fn);



        }
        function admin_top_menu($admin_bar) {
            global $wpdb;

            $crawlState = get_option("rssimporter_auto_crawl");

            if($crawlState == 'online')
            {
                $crawledAt = get_option("RSSImporterLastCrawlTime");

                if(!$crawledAt){

                //     $args = array(
                //         'id'     => 'rssimporter-crawl-error',
                //         'title'  => '<span style="color:#ff6969">مشکلی در رصد خودکار اخبار پیش آمده است، بررسی کنید.</span>',
                //         'href'   => esc_url( admin_url( 'admin.php?page=rssimporter-setting' ) ),
                //     );
                //     $admin_bar->add_node( $args );

                }
                else
                {

                }
            }

            $crawledAt = get_option("RSSImporterLastCrawlTime");


            $A =
            "<script>
            </script>";
            $status = $A.'<div style="position:absolute; top:50%; right:0px;" class="loader-6 center"><span></span></div>';// $crawlState == 'online' ? '<b style="color:#06fb06">روشن</b>' : '<b style="color:#ff6969">خاموش</b>';


            $publishState = get_option("RSSImporter_auto_publish");
            $isCrawling = ($crawlState && get_option("RSSImporter_is_crawling"));

            $Pstatus = $isCrawling ? ($status. '<span class="blinking" style="display: inline-block; padding-right: 10px;">در حال جستجو اخبار جدید</span>') : 'ربات درحال استراحت';

            $table = $wpdb->prefix . 'rssimporter_news';

            $date = _jdate(time());

            $today = $date->toCarbon()->format("Y-m-d");

            $todayPosts = $wpdb->get_results ( "SELECT news.id FROM  $table as news WHERE DATE(updated_at) = '$today' order by id desc");

            $updates = '';

            $updates.= '<div class="XMAX _crawled update-count" title="اخبار رصد شده امروز"><span class="clp wp-menu-image dashicons-before dashicons-download"></span> <span class="mxa">'.(count($todayPosts) == 0 ? 0 : '<b style="color:#06fb06">'.count($todayPosts).'</b>').'</span></div>';


            // get number of posts scanned today
            $todayPosts = $wpdb->get_results ( "SELECT news.id FROM  $table as news WHERE status=1 AND DATE(updated_at) = '$today' order by id desc");

            $limit = get_option("RSSImporter_repost_daily_count") ?: 50;

            if($limit < count($todayPosts))
            {
                $color = "#ec3939";
            }
            else if($limit == count($todayPosts))
            {
                $color = "#64a4f9";
            }
            else if ($limit > count($todayPosts))
            {
                $color = "#20ff00";
            }
            $updates.= '<div class="XMAX _saved update-count" title="اخبار ذخیره شده در وردپرس امروز"><span class="clp wp-menu-image dashicons-before dashicons-wordpress"></span> <span class="mxa">'.(count($todayPosts) == 0 ? 0 : '<b style="color: '.$color.'">'.$limit.'/'.count($todayPosts).'</b>').'</span></div>';

            $args = array(
                'id'     => 'rssimporter-menu',
                'title'  => '<div style="display: inline-block;" class="'.($isCrawling ? 'active ' : '').'wp-menu-image dashicons-before dashicons-rest-api" aria-hidden="true"></div> '. $Pstatus .$updates,
            );

            $admin_bar->add_node( $args );



            // add a child item to our parent item
            $args = array(
                'parent' => 'rssimporter-menu',
                'id'     => 'rssimporter-downloaded',
                'title'  => 'نمایش ترطیب انتشار خودکار',
                'href'   => esc_url( admin_url( 'admin.php?page=rssimporter&act=auto' ) ),
                'meta'   => false
            );

            $admin_bar->add_node( $args );

            if($crawlState == 'online')
            {

                // add a child item to our parent item
                $args = array(
                    'parent' => 'rssimporter-menu',
                    'id'     => 'rssimporter-off',
                    'title'  => 'خاموش کردن',
                    'href'   => esc_url( admin_url( 'admin.php?page=rssimporter-setting&toggleSystem' ) ),
                    'meta'   => false
                );
                $admin_bar->add_node( $args );
            }
            else
            {
                // add a child item to our parent item
                $args = array(
                    'parent' => 'rssimporter-menu',
                    'id'     => 'rssimporter-on',
                    'title'  => 'روشن کردن',
                    'href'   => esc_url( admin_url( 'admin.php?page=rssimporter-setting&toggleSystem' ) ),
                    'meta'   => false
                );
                $admin_bar->add_node( $args );
            }

        }

        public function screen_option()
        {

            $option = 'per_page';
            $args = [
                'label' => 'اخبار',
                'default' => 15,
                'option' => 'NEWS_per_page'
            ];

            add_screen_option( $option, $args );

            //Save the data from screen options
            add_filter( 'set-screen-option', 'rssScreenOptions', 11, 3 );

            function rssScreenOptions( $status, $option, $value ) {
                var_dump($option, $value);
                die();
                if ( 'NEWS_per_page' == $option ) return $value;
            }

            $this->newsTable = new \NewsFeedTable();
        }
        //--------------------------------------------------------------------

        /**
         * Display RSS Importer Main Page
         *
         * @return NULL
         */
        public function RSSImporterView()
        {

            /*

             code to update status 0 to 1
            global $wpdb;

            $sql = "SELECT news.* FROM {$wpdb->prefix}rssimporter_news AS news WHERE (SELECT meta.post_id FROM {$wpdb->prefix}postmeta as meta WHERE meta.meta_key = 'news_url' AND meta.meta_value = news.url LIMIT 1) IS NOT NULL";

            $result = $wpdb->get_results( $sql, 'ARRAY_A' );
            foreach ($result as $key => $value) {

                $table = $wpdb->prefix . 'rssimporter_news';

                // update news draft status to published
                $wpdb->update($table, [
                    'status' => 1
                ], ['id'=>$value['id']]);

            }
            die('as');
            */
            $crawler = new \RSSImporter\Included\Importer\Crawler;
            if(isset($_GET['new']))
            {
                if(@$_POST['save'])
                {
                    try {
                        $crawler->addFeed();
                        \FeedTable::record_count_active();
                    } catch (\Exception $th) {
                        //throw $th;
                    }

                    wp_redirect( wp_get_referer());
                    echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter-feeds').'">';
                    die();
                }
                include_once RSS_IMPORTER_DIR_PATH."Include/Importer/Reader.php";
                include_once RSS_IMPORTER_DIR_PATH."views/admin/add_feed.php";
                return NULL;
            }
            else
            {

                $newsFeedTable = $this->newsTable;
            }

            //
            include_once RSS_IMPORTER_DIR_PATH."views/admin/news_table.php";
        }

        //--------------------------------------------------------------------

        /**
         * Display Feeds Table Page
         *
         * @return NULL
         */
        public function FeedsTableView()
        {
            global $wpdb;

            $FeedTable = $this->feedsTable;

            switch (@$_GET['action']) {
                case 'modify':
                    $source = (int)@$_GET['feed'];

                    $feed = \RSSImporter\Included\Importer\Crawler::getSourceByID((int)$source);
                    if(!empty($_POST))
                    {
                        $table = $wpdb->prefix . 'rssimporter_feeds';

                        $toCat          = (@$_POST['select_category'] && @$_POST['cat']) ? (int)$_POST['cat'] : 0;
                        $change_links_to = (@$_POST['change_links_to'] && @$_POST['change_links_to_url']) ? $_POST['change_links_to_url'] : '';

                        $replaceables = [];

                        if(!empty(@$_POST['replace_from']) && !empty(@$_POST['replace_to']))
                        {
                            foreach ($_POST['replace_from'] as $key => $value) {
                                if(!empty($value) && !empty(@$_POST['replace_to'][$key]))
                                $replaceables[$value] = @$_POST['replace_to'][$key];
                            }
                        }

                        $data = [
                            'replaceables'  => json_encode($replaceables),
                            'imported_categories' => $toCat,
                            'change_links_to' => $change_links_to,
                            'add_source_link'   => @$_POST['add_source_link'] ? 1 : 0,
                            'watermark_position' => @$_POST['watermark'] ? @$_POST['watermark_position'] : '',
                        ];

                        $updated = $wpdb->update( $table, $data, ['id'=>$feed->id] );
                        if ( false === $updated ) {
                            echo "خطا";
                        } else {
                            wp_redirect( wp_get_referer());
                            echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter-feeds').'">';
                            die();
                        }
                    }

                    if(!$feed){

                        wp_redirect( wp_get_referer());
                        echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter-feeds').'">';
                        die();
                    }

                    $feed = \RSSImporter\Included\Importer\Crawler::getSourceByID((int)$source);

                    include_once RSS_IMPORTER_DIR_PATH."views/admin/modify_feed.php";
                    return;
                    break;

                default:
                    # code...
                    break;
            }
            //
            include_once RSS_IMPORTER_DIR_PATH."views/admin/feeds_table.php";
        }

        //--------------------------------------------------------------------

        /**
         * Display Settings Page
         *
         * @return NULL
         */
        public function SettingsView()
        {
            if(isset($_GET['deletetWatermark']))
            {
                self::deleteWatermark();
                wp_redirect( wp_get_referer());
                echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter-setting').'">';
                die();
            }

            if(isset($_GET['toggleSystem']))
            {
                if(get_option("rssimporter_auto_crawl") == 'online')
                {
                    delete_option("rssimporter_auto_crawl");
                }
                else
                {
                    add_option("rssimporter_auto_crawl", 'online'); // turn online
                }
                echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter-setting').'">';
                wp_redirect( wp_get_referer());
                die();
            }

            if(!empty($_POST))
            {
                if(@$_POST['truncDB'])
                {
                    global $wpdb;
                    if(@$_POST['tranc_news'])
                    {
                        $wpdb->query("TRUNCATE TABLE {$wpdb->prefix}rssimporter_news");
                    }
                    if(@$_POST['tranc_feeds'])
                    {
                        $wpdb->query("TRUNCATE TABLE {$wpdb->prefix}rssimporter_feeds");
                    }
                    wp_redirect( wp_get_referer());
                    echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter-setting').'">';
                    die();
                }


                switch (@$_POST['save']) {
                    case 'crawl':

                        if(is_numeric(@$_POST['RSSImporter_crawl_every']))
                        {
                            update_option("RSSImporter_crawl_every", (int) $_POST['RSSImporter_crawl_every']);
                        }
                        if(is_numeric(@$_POST['RSSImporter_delete_crawled_every']))
                        {
                            update_option("RSSImporter_delete_crawled_every", (int) $_POST['RSSImporter_delete_crawled_every']);
                        }
                        if(is_numeric(@$_POST['RSSImporter_crawl_limited_to']))
                        {
                            update_option("RSSImporter_crawl_limited_to", (int) $_POST['RSSImporter_crawl_limited_to']);
                        }
                        wp_redirect( wp_get_referer());
                        echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter-setting').'">';
                        die();
                        break;
                    case 'publish':

                        update_option("RSSImporter_theme_lead_metakey", $_POST['RSSImporter_theme_lead_metakey']);
                        update_option("RSSImporter_repost_daily_count", (int)@$_POST['RSSImporter_repost_daily_count']);
                        update_option("RSSImporter_repost_delay_minutes", (int)(@$_POST['RSSImporter_repost_delay_minutes'] ?: 5));
                        update_option("RSSImporter_repost_from_hour", (int)@$_POST['RSSImporter_repost_from_hour']);
                        update_option("RSSImporter_repost_to_hour", (int)@$_POST['RSSImporter_repost_to_hour']);
                        $uploadedfile = @$_FILES['watermark_img'];
                        if($uploadedfile)
                        {

                            if ( ! function_exists( 'wp_handle_upload' ) ) {
                                require_once( ABSPATH . 'wp-admin/includes/file.php' );
                            }


                            /* You can use wp_check_filetype() function to check the
                            file type and go on wit the upload or stop it.*/

                            $movefile = wp_handle_upload( $uploadedfile,['test_form' => false]);

                            if ( $movefile && !isset( $movefile['error'] ) ) {

                                if($img = get_option("RSSImporter_watermark")){
                                    self::deleteWatermark();
                                }

                                update_option('RSSImporter_watermark', $movefile['url']);
                                update_option('RSSImporter_watermark_path', $movefile['file']);
                            } else {
                                /**
                                 * Error generated by _wp_handle_upload()
                                 * @see _wp_handle_upload() in wp-admin/includes/file.php
                                 */
                            }

                        }

                        wp_redirect( wp_get_referer());
                        echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter-setting').'">';
                        die();
                        break;
                    default:
                        # code...
                        break;
                }
            }

            //
            include_once RSS_IMPORTER_DIR_PATH."views/admin/settings.php";
        }

        private static function deleteWatermark ()
        {
            if(file_exists(get_option("RSSImporter_watermark_path"))){
                unlink(get_option("RSSImporter_watermark_path"));
                delete_option("RSSImporter_watermark");
                delete_option("RSSImporter_watermark_path");
            }
            else
            {
                delete_option("RSSImporter_watermark");
                delete_option("RSSImporter_watermark_path");
            }
        }

        // -----------------------------------------------

        public function bugReport()
        {

            return new WP_REST_Response( [
                'OK' => false,
                'feeds'  => [],
            ], 200 );
        }

    }
}
