<?php
namespace RSSImporter\Included\Importer\CrawlTargets;

use \RSSImporter\Included\Importer\Crawler;
use \RSSImporter\Included\Importer\CrawlTargetInterface;

class EghtesadNews extends Crawler implements CrawlTargetInterface
{
    public function loadNews(string $url):array
    {
        $pageData = \RSSImporter\Included\Importer\Crawler::request($url);
        $postData = [];
        if($pageData)
        {
            $dom = new \DOMDocument();

            $dom->validateOnParse = true; //<!-- this first
            @$dom->loadHTML('<?xml encoding="utf-8" ?>'.$pageData);        //'cause 'load' == 'parse
            $dom->preserveWhiteSpace = false;
            /* get the element to be deleted */
            $div=$dom->getElementById('related-news');

            /* delete the node */
            if( $div && $div->nodeType==XML_ELEMENT_NODE ){
                $div->parentNode->removeChild( $div );
            }

            $finder = new \DomXPath($dom);
            $classname="item-header";
            $postData['main_image'] = @$finder->query("//a[@class='res']/img/@src")[0]->value;


            $postData['title'] = trim(@$finder->query("//div[@class='title']/h1")[0]->textContent);
            $postData['introtext'] = trim(@$finder->query("//div[@class='lead']")[0]->textContent);
            

            $postData['body']     = trim($dom->saveHTML(@$finder->query("//div[@class='innerbody']")[0]));
            $postData['categories'] = $this->extractCategories($finder);
            $postData['tags'] = $this->extractTags($finder);

            if(empty($postData['title']) || empty($postData['body']))
                return [];

        }
        else
            throw new \Exception("Could not crawl data.", 1);
         

        return $postData;
    }

    private function extractCategories(\DomXPath $finder):array
    {
        return [];
        $dom = new \DOMDocument('1.0');

        $entries = $finder->query('(//h2[@class="category-name d-flex justify-content-center"])/span');
        $categories = [];

        foreach ($entries as $OL)
        {
            $categories[] = trim(ltrim(rtrim($OL->textContent)));//trim(@$dom->saveXML($OL));//
        }

        return $categories;
    }

    private function extractTags(\DomXPath $finder):array
    {
        $dom = new \DOMDocument('1.0');

        $entries = $finder->query('(//div[@class="tags cont noprint"])/ul/li');
        
        $categories = [];

        foreach ($entries as $OL)
        {
            $categories[] = trim(ltrim(rtrim($OL->textContent)));//trim(@$dom->saveXML($OL));//
        }

        return $categories;
    }
}
