<?php
namespace RSSImporter\Included\Importer\CrawlTargets;

use \RSSImporter\Included\Importer\Crawler;
use \RSSImporter\Included\Importer\CrawlTargetInterface;

class EghtesadoTejarat extends Crawler implements CrawlTargetInterface
{
    public function loadNews(string $url):array
    {
        $pageData = \RSSImporter\Included\Importer\Crawler::request($url);

        $postData = [];
        if($pageData)
        {
            $dom = new \DOMDocument();

            $dom->validateOnParse = true; //<!-- this first
            @$dom->loadHTML('<?xml encoding="utf-8" ?>'.$pageData);        //'cause 'load' == 'parse
            $dom->preserveWhiteSpace = false;
            $finder = new \DomXPath($dom);
            $classname="item-header";
            $postData['main_image'] = @$finder->query("//div[@class='box-inline']/a/img/@src")[0]->value;


            $postData['title'] = trim(@$finder->query("//h1[@class='single-post-title']")[0]->textContent);
            $postData['introtext'] = trim(@$finder->query("//div[@class='lead']/b")[0]->textContent);
            $postData['body']     = trim($dom->saveHTML(@$finder->query("//div[@class='con']")[0]));
            $postData['categories'] = $this->extractCategories($finder);

            if(empty($postData['title']) || empty($postData['body']))
                return [];

        }
        else
            throw new \Exception("Could not crawl data.", 1);
         

        return $postData;
    }

    private function extractCategories(\DomXPath $finder):array
    {
        return [];
        $dom = new \DOMDocument('1.0');

        $entries = $finder->query('(//h2[@class="category-name d-flex justify-content-center"])/span');
        $categories = [];

        foreach ($entries as $OL)
        {
            $categories[] = trim(ltrim(rtrim($OL->textContent)));//trim(@$dom->saveXML($OL));//
        }

        return $categories;
    }
}
