<?php
namespace RSSImporter\Included\Importer\CrawlTargets;

use \RSSImporter\Included\Importer\Crawler;
use \RSSImporter\Included\Importer\CrawlTargetInterface;

class FarsNews extends Crawler implements CrawlTargetInterface
{
    public function loadNews(string $url):array
    {
        $pageData = \RSSImporter\Included\Importer\Crawler::request($url);
        
        $postData = [];
        if($pageData)
        {
            $dom = new \DOMDocument();

            $dom->validateOnParse = true; //<!-- this first
            @$dom->loadHTML('<?xml encoding="utf-8" ?>'.$pageData);        //'cause 'load' == 'parse
            $dom->preserveWhiteSpace = false;
            $finder = new \DomXPath($dom);
            $classname="item-header";
            $postData['main_image'] = @$finder->query("//figure/img/@src")[0]->value;

            $postData['title'] = trim(@$finder->query("//h1[@class='title mb-2 d-block text-justify']")[0]->textContent);
            $postData['introtext'] = trim(@$finder->query("//p[@class='lead p-2 text-justify radius']")[0]->textContent);
            $postData['body']     = trim($dom->saveHTML(@$finder->query("//div[@class='nt-body text-right mt-4']")[0]));
            $postData['categories'] = $this->extractCategories($finder);
            
            if(empty($postData['title']) || empty($postData['body']))
                return [];

        }
        else
            throw new \Exception("Could not crawl data.", 1);
         

        return $postData;
    }

    private function extractCategories(\DomXPath $finder):array
    {
        $dom = new \DOMDocument('1.0');

        $entries = $finder->query('(//h2[@class="category-name d-flex justify-content-center"])/span/a');
        $categories = [];
        foreach ($entries as $OL)
        {   
            $v = trim((($OL->textContent)));
            if(empty($v))
                continue;
            $categories[] = $v;//trim(@$dom->saveXML($OL));//
        }

        return $categories;
    }
}
