<?php
namespace RSSImporter\Included\Importer\CrawlTargets;

use \RSSImporter\Included\Importer\Crawler;
use \RSSImporter\Included\Importer\CrawlTargetInterface;

class HonarOnline extends Crawler implements CrawlTargetInterface
{
    public function loadNews(string $url):array
    {
        $pageData = \RSSImporter\Included\Importer\Crawler::request($url);
        $postData = [];
        if($pageData)
        {
            $dom = new \DOMDocument();

            $dom->validateOnParse = true; //<!-- this first
            @$dom->loadHTML('<?xml encoding="utf-8" ?>'.$pageData);        //'cause 'load' == 'parse
            $dom->preserveWhiteSpace = false;
            /* get the element to be deleted */
            $div=$dom->getElementById('related-news');

            /* delete the node */
            if( $div && $div->nodeType==XML_ELEMENT_NODE ){
                $div->parentNode->removeChild( $div );
            }

            $finder = new \DomXPath($dom);
            $classname="item-header";
            $postData['main_image'] = @$finder->query("//a[@class='block']/img/@src")[0]->value;


            $postData['title'] = trim(@$finder->query("//h1")[0]->textContent);
            $postData['introtext'] = trim(@$finder->query("//p[@class='lead']")[0]->textContent);
            

            $postData['body']     = trim($dom->saveHTML(@$finder->query("//div[@class='album-view-check']")[0]));
            $postData['categories'] = $this->extractCategories($finder);
            $postData['tags'] = $this->extractTags($finder);

            if(empty($postData['title']) || empty($postData['body']))
                return [];

        }
        else
            throw new \Exception("Could not crawl data.", 1);
         

        return $postData;
    }

    private function extractCategories(\DomXPath $finder):array
    {
        return [];
    }

    private function extractTags(\DomXPath $finder):array
    {
        $dom = new \DOMDocument('1.0');

        $entries = $finder->query('(//section[@class="word_key fn14 mt16 mb16 noprint clearbox"])/a');
        
        $tag = [];

        foreach ($entries as $A)
        {
            $tag[] = trim(ltrim(rtrim($A->textContent)));//trim(@$dom->saveXML($OL));//
        }

        return $tag;
    }
}
