<?php
namespace RSSImporter\Included\Importer\CrawlTargets;

use \RSSImporter\Included\Importer\Crawler;
use \RSSImporter\Included\Importer\CrawlTargetInterface;

class Yjc extends Crawler implements CrawlTargetInterface
{
    public function loadNews(string $url):array
    {
        $pageData = \RSSImporter\Included\Importer\Crawler::request($url);

        $postData = [];

        if($pageData)
        {
            $dom = new \DOMDocument();

            $dom->validateOnParse = true; //<!-- this first
            @$dom->loadHTML('<?xml encoding="utf-8" ?>'.$pageData);        //'cause 'load' == 'parse
            $dom->preserveWhiteSpace = false;
            /* get the element to be deleted */
            $div=$dom->getElementById('related-news');

            /* delete the node */
            if( $div && $div->nodeType==XML_ELEMENT_NODE ){
                $div->parentNode->removeChild( $div );
            }

            $finder = new \DomXPath($dom);

            $postData['main_image'] = @$finder->query("//div[@class='parent-lead-img']/img/@src")[0]->value;


            $postData['title'] = trim(@$finder->query("//h1[@class='Htags']/span")[0]->textContent);
            $postData['introtext'] = trim(@$finder->query("//div[@class='subtitle baznashr-subtitle']")[0]->textContent);
            

            $postData['body']     = @$finder->query("//div[@class='row baznashr-body']")[0]->textContent;
            $postData['categories'] = $this->extractCategories($finder);
            $postData['tags'] = $this->extractTags($finder);

            if(empty($postData['title']) || empty($postData['body']))
                return [];

        }
        else
            throw new \Exception("Could not crawl data.", 1);
         

        return $postData;
    }

    private function extractCategories(\DomXPath $finder):array
    {
        $dom = new \DOMDocument('1.0');

        $entries = $finder->query('(//div[@class="parent-lead-img"])/div/a');
        $categories = [];

        foreach ($entries as $OL)
        {
            $cat = trim(ltrim(rtrim($OL->textContent)));
            if(!in_array($cat, $categories))
                $categories[] = $cat;//trim(@$dom->saveXML($OL));//
        }

        return $categories;
    }

    private function extractTags(\DomXPath $finder):array
    {
        $dom = new \DOMDocument('1.0');

        $entries = $finder->query('(//div[@class="tag_items_photo"])/a');
        
        $categories = [];

        foreach ($entries as $OL)
        {
            $categories[] = trim(ltrim(rtrim($OL->textContent)));//trim(@$dom->saveXML($OL));//
        }

        return $categories;
    }
}
