<?php

/**
 * Ahur Update Manager
 * Version: 1.0
 * Description: این افوزنه اسانس اهور است، تمامی پروژه های به من متصل میشوند.
 * Author: علی خالقی <awli.khaleghi@gmail.com>
 * Author URI: https://blog.ahur.ir
 * Plugin URI:  https://blog.ahur.ir
 */

if ( ! class_exists( 'AhurUpdates' ) ) {
    class AhurUpdates {
        /**
         * Constructor
         */
        public function __construct() {
            //
            
            $this->setup_methods();
        }
        
        // -----------------------------------------------

        /**
         * Setting up Hooks
         */
        public function setup_methods() {

            
			/**
			 * Ahur Bug Report API End Point
			 */
			add_action( 'rest_api_init', function () {
				register_rest_route( 'ahur_core/v1', '/report', array(
				'methods' => 'GET',
				'callback' => [$this, 'bugReport'],
					'args' => array(
						'id' => array(
							'validate_callback' => function($param, $request, $key) {
								return is_numeric( $param );
							}
						),
					),
					'permission_callback' => '__return_true'
				) );
			});
        }
        
        // -----------------------------------------------

        public function bugReport()
        {
    
            return new WP_REST_Response( [
                'OK' => false,
                'feeds'  => [],
            ], 200 );
        }
        
    }
}