<?php
use \RSSImporter\Included\Importer\Crawler;
if ( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}
// 
class FeedTable extends \WP_List_Table {
    public $watermark_url = NULL;
    
    public function __construct()
    {
        parent::__construct( [
            'singular' => __( 'خبرگذاری', 'sp' ), //singular name of the listed records
            'plural' => __( 'خبرگذاری ها', 'sp' ), //plural name of the listed records
            'ajax' => false //should this table support ajax?
            
        ] );

        $this->watermark_url = get_option("RSSImporter_watermark");
    }
    /**
     * Retrieve news data from the database
     *
     * @param int $per_page
     * @param int $page_number
     *
     * @return mixed
     */
    public static function get_news( $per_page = 10, $page_number = 1 ) {

        global $wpdb;
        
        $sql = "SELECT news.* FROM {$wpdb->prefix}rssimporter_feeds AS news ";

        if(@$_GET['act'] == 'inactive')
        {
            $sql .= "WHERE is_active=0 ";
        }
        else
        {
            $sql .= "WHERE is_active=1";
        }
        if ( ! empty( $_REQUEST['orderby'] ) ) {
            $sql .= ' ORDER BY ' . esc_sql( $_REQUEST['orderby'] );
            $sql .= ! empty( $_REQUEST['order'] ) ? ' ' . esc_sql( $_REQUEST['order'] ) : ' ASC';
        }
        else
        {
            $sql .= ' ORDER BY created_at DESC';
        }
        
        $sql .= " LIMIT $per_page";
        
        $sql .= ' OFFSET ' . ( $page_number - 1 ) * $per_page;
        
        $result = $wpdb->get_results( $sql, 'ARRAY_A' );
        
        return $result;
    }

    /**
     * Delete a news record.
     *
     * @param int $id news ID
     */
    public static function delete_feed( $id ) {
        global $wpdb;

        $wpdb->delete(
            "{$wpdb->prefix}rssimporter_feeds",
            [ 'id' => $id ],
            [ '%d' ]
        );
    }

    /**
     * Delete a news record.
     *
     * @param int $id news ID
     */
    public static function delete_news( $feed_id ) {
        global $wpdb;

        $wpdb->delete(
            "{$wpdb->prefix}rssimporter_news",
            [ 'feed_id' => $feed_id ],
            [ '%d' ]
        );
    }
    /**
    * Returns the count of records in the database.
    *
    * @return null|string
    */
    public static function record_count_active() {
        global $wpdb;

        $sql = "SELECT COUNT(*) FROM {$wpdb->prefix}rssimporter_feeds as feeds";

        $sql .= " WHERE is_active = 1";
        $count = $wpdb->get_var( $sql );
        update_option("rssimporter_active_feed_count",$count);

        return $count;
    }
    /**
    * Returns the count of records in the database.
    *
    * @return null|string
    */
    public static function record_count_inactive() {
        global $wpdb;

        $sql = "SELECT COUNT(*) FROM {$wpdb->prefix}rssimporter_feeds as feeds";

        $sql .= " WHERE is_active = 0";
        $count = $wpdb->get_var( $sql );


        return $count;
    }

    /** Text displayed when no feed data is available */
    public function no_items() {
        _e( 'هیچ خبرگذاری ثبت نشده است.', 'sp' );
    }

    /**
     * Method for title column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_name( $item )
    {

        // create a nonce
        $delete_nonce = wp_create_nonce( 'sp_delete_feed' );
        $activate_nonce = wp_create_nonce( 'sp_activate' );

        $title = '<strong>' . $item['name'] . '</strong>';
        $title.="<hr/>";
        $title.= $item['description'];
        $actions = [
            'delete' => sprintf( '<a href="?page=%s&action=%s&feed=%s&_wpnonce=%s">حذف منبع و اخبار</a>', esc_attr( $_REQUEST['page'] ), 'delete', absint( $item['id'] ), $delete_nonce ),
            'modify' => sprintf( '<a href="?page=%s&action=%s&feed=%s&_wpnonce=%s">ویرایش</a>', esc_attr( $_REQUEST['page'] ), 'modify', absint( $item['id'] ), $activate_nonce )
        ];

        return $title . $this->row_actions( $actions );
    } 

    /**
     * Method for source column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_imported_categories( $item )
    {
        if($item['imported_categories'] == 0) return 'خودکار';
        return @get_term_by('id', $item['imported_categories'], 'category')->name ?: (" یافت نشد");
    }

    /**
     * Method for is_active column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_is_active( $item )
    {
        
        if($item['is_active'] == 1)
        {
            $deactivate_nonce = wp_create_nonce( 'sp_deactivate' );

            $actions = [
                'deactivate' => sprintf( '<a href="?page=%s&action=%s&feed=%s&_wpnonce=%s">خاموش کردن</a>', esc_attr( $_REQUEST['page'] ), 'deactivate', absint( $item['id'] ), $deactivate_nonce ),
            ];
        }
        else
        {
            $activate_nonce = wp_create_nonce( 'sp_activate' );
                
            $actions = [
                'activate' => sprintf( '<a href="?page=%s&action=%s&feed=%s&_wpnonce=%s">روشن کردن</a>', esc_attr( $_REQUEST['page'] ), 'activate', absint( $item['id'] ), $activate_nonce ),
            ];
        }

        return ($item['is_active'] == 1 ? "روشن" : "خاموش") . $this->row_actions( $actions );

    }

    /**
     * Method for created_at column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_created_at( $item )
    {

        $date = _jdate(strtotime($item['created_at']));
                
        $now = $date->format(get_option( 'date_format' ));

        return  $now;
    }
    
    function convertSeconds($iSeconds)
    {
       $min = intval($iSeconds / 60);
       return $min . ':' . str_pad(($iSeconds % 60), 2, '0', STR_PAD_LEFT);
    }
    
    /**
     * Method for crawled_at column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_crawled_at( $item )
    {
        
        $crawled_at = $item['crawled_at'];

        $to_time = time();
        $from_time = strtotime($crawled_at);

        $minutesPassedSinceLastCrawl = round(abs($to_time - $from_time) / 60,2);
        $timeLeft = strtotime($crawled_at. " + 5 minute") - time();

        $date = _jdate(strtotime($item['crawled_at']));
                
        $crawled_at = $date->format(get_option( 'date_format' ));

        $i = $item['crawled_at'] ? '<span data-time="'.$timeLeft.'" class="cds">'.$crawled_at.'<p class="timer"></p></span>' : 'رصد انجام نشده است';  
        
        return  $i;
    }

    /**
     * Method for column_watermark_position column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_watermark_position( $item )
    {
        if($img = get_option("RSSImporter_watermark"))
        {
            ?>
            <img style="max-width:100%;" src="<?=$img?>"/>    
            <?php
        }
        else
        {
            ?>
            <a class="ui red label" href="<?=admin_url('admin.php?page=rssimporter-setting')?>">تصویر واترمارک ثبت نشده است</a>
            <?php
        }
        echo "<hr/>";
        switch ($item['watermark_position']) {
            case 'POSITION_TOP_LEFT':
                $pos = 'بالا چپ';
                break;
            case 'POSITION_TOP':
                $pos = 'بالا وسط';
                break;
            case 'POSITION_TOP_RIGHT':
                $pos = 'بالا راست';
                break;
            case 'POSITION_LEFT':
                $pos = 'چپ';
                break;
            case 'POSITION_CENTER':
                $pos = 'وسط';
                break;
            case 'POSITION_RIGHT':
                $pos = 'راست';
                break;
            case 'POSITION_BOTTOM_LEFT':
                $pos = 'پاین چپ';
                break;
            case 'POSITION_BOTTOM':
                $pos = 'پایین وسط';
                break;
            case 'POSITION_BOTTOM_RIGHT':
                $pos = 'پایین راست';
                break;

            
            default:
                $pos = $item['watermark_position'] ?: "ثبت نشده است";
                break;
        }
        return  $pos;
    }
    /**
     * Method for add_source_link column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_add_source_link( $item )
    {
        return  $item['add_source_link'] ? "بله" : "خیر" ;
    }

    /**
     * Method for source column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_source( $item )
    {
        
        return $item['feed_url'];
    }

    /**
     * Method for source column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_count( $item )
    { 
        
        return Crawler::countNewsForFeed((int)@$item['id'] );
    }
    

    public function single_row( $item ) {
        $status = $item['is_active'] == 1 ? '#ceecce' : '#eec4c4';
        $r = $item['is_active'] == 1 ? 'white' : '';
        $x = $item['is_active'] == 1 ? '_active' : '';
        echo '<tr class="'.$x.'" style="background: '.$status.'; color: '.$r.'">';
        $this->single_row_columns( $item );
        echo '</tr>';
    }
    /**
    * Render a column when no column specific method exists.
    *
    * @param array $item
    * @param string $column_name
    *
    * @return mixed
    */
    public function column_default( $item, $column_name ) {
        switch ( $column_name ) {
            case 'intro':
            case 'id':
                return $item[ $column_name ];
            case 'title':
                return $img . $item[ $column_name ];
                break;
            default:
                return print_r( $item, true ); //Show the whole array for troubleshooting purposes
        }
    }
    /**
    * Render the bulk edit checkbox
    *
    * @param array $item
    *
    * @return string
    */
    function column_cb( $item ) {
        return sprintf(
        '<input type="checkbox" name="bulk-delete[]" value="%s" />', $item['id']
        );
    }
    /**
    * Associative array of columns
    *
    * @return array
    */
    function get_columns() {
        $columns = [
            'cb' => '<input type="checkbox" />',
            'name' => __( 'تیتر', 'sp' ),
            'source' => __( 'آدرس منبع', 'sp' ),
            'count' => __('اخبار رصد شده','sp'),
            'imported_categories' => __( 'دسته بندی', 'sp' ),
            'watermark_position' => __( 'واترمارک', 'sp' ),
            'add_source_link' => __( 'درج لینک منبع', 'sp' ),
            'is_active' => __( 'وضعیت', 'sp' ),
            'crawled_at' => __( 'تاریخ آخرین رصد', 'sp' ),
            'created_at' => __( 'تاریخ ثبت', 'sp' ),
        ];

        return $columns;
    }
    /**
    * Columns to make sortable.
    *
    * @return array
    */
    public function get_sortable_columns() {
        $sortable_columns = array(
            'id' => array( 'id', true ),
            'title' => array( 'title', false ),
            'feed_id' => array( 'feed_id', false )
        );

        return $sortable_columns;
    }
    /**
    * Returns an associative array containing the bulk action
    *
    * @return array
    */
    public function get_bulk_actions() {
        
        $actions = [];

        if(@$_GET['act'] == 'inactive')
        {
            $actions['bulk-activate'] = 'فعال کردن';
        }
        else {

            $actions['bulk-deactivate'] = 'غیرفعال کردن';
        }

        $actions['bulk-delete'] = 'حذف منبع و اخبار';

        return $actions;
    }
    /**
    * Handles data query and filter, sorting, and pagination.
    */
    public function prepare_items() {

        $this->_column_headers = $this->get_column_info();
        
        /** Process bulk action */
        $this->process_bulk_action();

        $per_page = $this->get_items_per_page( 'news_per_page', 15 );
        $current_page = $this->get_pagenum();
        if(@$_GET['act'] == 'inactive')
        {
            $total_items = self::record_count_inactive();
            
        }
        else
            $total_items = self::record_count_active();

        $this->set_pagination_args( [
            'total_items' => $total_items, //WE have to calculate the total number of items
            'per_page' => $per_page //WE have to determine how many items to show on a page
        ] );

        $this->items = self::get_news( $per_page, $current_page );
    }
    public function process_bulk_action() {

        //Detect when a bulk action is being triggered...
        if ( 'activate' === $this->current_action() ) {
            // In our file that handles the request, verify the nonce.
            $nonce = esc_attr( $_REQUEST['_wpnonce'] );

            if ( ! wp_verify_nonce( $nonce, 'sp_activate' ) ) {
                die( 'Go get a life script kiddies' );
            }
            else
            {
                Crawler::updateFeed((int)@$_GET['feed'], [
                    'is_active' => 1
                ] );;

                wp_redirect( wp_get_referer());
                echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter-feeds&act=active').'">';
                exit;
            }
        }

        //Detect when a bulk action is being triggered...
        if ( 'deactivate' === $this->current_action() ) {
            // In our file that handles the request, verify the nonce.
            $nonce = esc_attr( $_REQUEST['_wpnonce'] );

            if ( ! wp_verify_nonce( $nonce, 'sp_deactivate' ) ) {
                die( 'Go get a life script kiddies' );
            }
            else
            {
                Crawler::updateFeed((int)@$_GET['feed'], [
                    'is_active' => 0
                ] );
                wp_redirect( wp_get_referer());
                echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter-feeds&act=inactive').'">';
                exit(1);
            }
        }

        if ( 'publish' === $this->current_action() ) {
            $nonce = esc_attr( $_REQUEST['_wpnonce'] );

            if ( ! wp_verify_nonce( $nonce, 'sp_publish_news' ) ) {
                die( 'Go get a life script kiddies' );
            }
            else {
                $news = Crawler::getNewsByID(@$_GET['news']);

                $parent = null;
                $catIDs = [];
                foreach (explode(",",$news->categories) as $key => $cat)
                {
                    if(!$parent)
                    {

                        $category = get_term_by('name', $cat, 'category');
                        if(!$category)
                        {
                            //create the main category
                            $parent = (object)wp_insert_term(
    
                                // the name of the category
                                $cat, 
                                'category', 
                                array(
                                
                                    'slug' => $cat,  
                                )
                            );
                        }
                        else
                            $parent = $category;
                        $catIDs[] = $parent->term_id;
                    }
                    else
                    { 
                        $category = get_term_by('name', $cat, 'category');
                        if(!$category)
                        {

                            if(!isset($parent->term_id))
                            var_dump($parent);
    
                            $parent = (object)wp_insert_term(
    
                                // the name of the sub-category
                                $cat, 
                                
                                // the taxonomy 'category' (don't change)
                                'category',
                                
                                array(
                                    // what to use in the url for term archive
                                    'slug' => $cat, 
                                    // link with main category. In the case, become a child of the "Category A" parent  
                                    'parent'=> $parent->term_id
                                
                                )
                            );
                        }
                        else
                        {
                            $parent = $category;

                        }

                        var_dump($parent);
                        $catIDs[] = $parent->term_id ;

                    }
                }

                global $user_ID;
                $new_post = array(
                    'post_title' => $news->title,
                    'post_content' => $news->intro . '<!--more-->' . $news->full_content,
                    'post_status' => 'publish',
                    'post_date' => date('Y-m-d H:i:s'),
                    'post_author' => $user_ID,
                    'post_type' => 'post',
                    'post_category' => $catIDs,
                    'meta_input' => array(
                        'news_url' => $news->url,
                    )
                );
                $post_id = wp_insert_post($new_post);

                wp_redirect( esc_url( add_query_arg() ) );
                echo ' <meta http-equiv="refresh" content="0;url='.esc_url( add_query_arg() ).'">';
                die();
                exit;
            }
        }
            //Detect when a bulk action is being triggered...
        if ( 'delete' === $this->current_action() ) {
            // In our file that handles the request, verify the nonce.
            $nonce = esc_attr( $_REQUEST['_wpnonce'] );

            if ( ! wp_verify_nonce( $nonce, 'sp_delete_feed' ) ) {
                die( 'Go get a life script kiddies' );
            }
            else
            {
                self::delete_feed( (int)@$_GET['feed'] );
                self::delete_news( (int)@$_GET['feed'] );
                self::record_count();
                \NewsFeedTable::record_count();

                wp_redirect( wp_get_referer());
                echo ' <meta http-equiv="refresh" content="0;url='.wp_get_referer().'">';
                die();
                exit;
            }
        }

        // If the delete bulk action is triggered
        if ( ( isset( $_POST['action'] ) && $_POST['action'] == 'bulk-activate' )
            || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-activate' )
            ) {

            $activate = esc_sql( $_POST['bulk-delete'] );
            // loop over the array of record IDs and delete them
            foreach ( $activate as $id ) {
                
                Crawler::updateFeed((int)@$id, [
                    'is_active' => 1
                ] );
            }

            self::record_count();
			\NewsFeedTable::record_count();
            echo ' <meta http-equiv="refresh" content="0;url='.esc_url( add_query_arg() ).'">';

            @wp_redirect( esc_url( add_query_arg() ) );
            exit;
        }


        // If the delete bulk action is triggered
        if ( ( isset( $_POST['action'] ) && $_POST['action'] == 'bulk-deactivate' )
            || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-deactivate' )
            ) {

            $deactivate = esc_sql( $_POST['bulk-delete'] );
            // loop over the array of record IDs and delete them
            foreach ( $deactivate as $id ) {
                
                Crawler::updateFeed((int)@$id, [
                    'is_active' => 0
                ] );
            }

            self::record_count();
			\NewsFeedTable::record_count();

            echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter-feeds&act=inactive').'">';
            @wp_redirect( admin_url('admin.php?page=rssimporter-feeds&act=inactive') );
            exit;
        }

        // If the delete bulk action is triggered
        if ( ( isset( $_POST['action'] ) && $_POST['action'] == 'bulk-delete' )
            || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-delete' )
            ) {

            $delete_ids = esc_sql( $_POST['bulk-delete'] );

            // loop over the array of record IDs and delete them
            foreach ( $delete_ids as $id ) {
                self::delete_feed( $id );
                self::delete_news( $id );

            }
            self::record_count();
			\NewsFeedTable::record_count();

            echo ' <meta http-equiv="refresh" content="0;url='.esc_url( add_query_arg() ).'">';
            @wp_redirect( esc_url( add_query_arg() ) );
            exit;
        }
    }


}