<?php

use \RSSImporter\Included\Importer\Crawler;
if ( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}
// 
class NewsFeedTable extends \WP_List_Table {
    
    public function __construct()
    {
        parent::__construct( [
            'singular' => __( 'خبر', 'sp' ), //singular name of the listed records
            'plural' => __( 'اخبار', 'sp' ), //plural name of the listed records
            'ajax' => false //should this table support ajax?
            
        ] );
    }

    /**
     * Delete a news record.
     *
     * @param int $id news ID
     */
    public static function delete_news( $id ) {
        global $wpdb;

        $wpdb->delete(
            "{$wpdb->prefix}rssimporter_news",
            [ 'id' => $id ],
            [ '%d' ]
        );
    }
    
    function extra_tablenav( $which )
    {
        global $wpdb;
        
        if(!function_exists("_selected"))
        {
            function _selected($current, $value)
            {
                return $current == $value ? 'selected' : '';
            }
        }
        switch ( $which )
        {
            case 'top':
                $sql = "SELECT categories FROM {$wpdb->prefix}rssimporter_news as news group by categories";
                $currentCat = @$_GET['cat'];

                $result = $wpdb->get_results( $sql, 'ARRAY_A' );
                $output = [];

                foreach ($result as $key => $value)
                {
                    $exploded = explode(",", $value['categories']);
                    if(count($exploded) >= 2)
                    {
                        foreach ($exploded as $key => $value)
                        {
                            if($key == 0)
                            {
                                if(!is_array(@$output[$value]))
                                {
                                        $output[$value] = [$exploded[1]];
                                }
                                else
                                {
                                    if(!in_array($exploded[1], $output[$value]))
                                    {
                                        $output[$value][] = $exploded[1];
                                    }
                                }
                            }
                        }
                    }
                }

                $wp_query = remove_query_arg('cat');
                $link = esc_url_raw($wp_query);

                ?>
                <select name="cat" id="filter-by-cat">
                    <option <?php selected( $currentCat, 0 ); ?> data-rc="<?php _e($link); ?>" value="0"><?php _e( 'همه دسته ها' ); ?></option>
                    <?php
                        foreach ($output as $key => $value)
                        {
                            if(is_array($value))
                            {
                                ?>
                                    <optgroup label="<?=$key?>">
                                    <?php
                                    foreach ($value as $key => $subCat)
                                    {
                                        $wp_query = add_query_arg('cat', $subCat);
                                        $link = esc_url_raw($wp_query);
                                        ?>
                                        <option <?php selected( $currentCat, $subCat ); ?> data-rc="<?php _e($link); ?>" value="<?=$subCat?>"><?php _e($subCat); ?></option>
                                        <?php
                                    }
                                    ?>
                                    </optgroup>
                                <?php
                            }
                        }
                    ?>
                </select>
                <a href="javascript:void(0)" class="button" onclick="window.location.href = jQuery('#filter-by-cat option:selected').data('rc');">فیلتر کنید</a>
                <?php
                $currentFeed = @$_GET['feed'];
                $wp_query = remove_query_arg('feed');
                $link = esc_url_raw($wp_query);
                $crawler = new Crawler;
                $feeds = $crawler->getActiveFeeds();

                ?>
                <select name="feed" id="filter-by-feed">
                    <option <?php selected( $currentFeed, 0 ); ?> data-rc="<?php _e($link); ?>" value="0"><?php _e( 'همه خبرگزاری ها' ); ?></option>
                    <?php
                        foreach ($feeds as $key => $value)
                        {
                            $wp_query = add_query_arg('feed', $value->id);
                            $link = esc_url_raw($wp_query);
                            ?>
                                <option <?php selected( $currentFeed, $value->id ); ?> data-rc="<?php _e($link); ?>" value="<?=$value->id?>"><?php _e($value->name); ?></option>
                            <?php
                        }
                    ?>
                </select>
                <a href="javascript:void(0)" class="button" onclick="window.location.href = jQuery('#filter-by-feed option:selected').data('rc');">فیلتر کنید</a>
                <?php



                $categories = '';
                break;

            case 'bottom':
                // Your html code to output
                break;
        }
    }
    public static function record_count_posted()
    {
        global $wpdb;


        $sql = "SELECT COUNT(*) FROM {$wpdb->prefix}rssimporter_news as news";
        $sql .= " WHERE status = 1";
        $count = $wpdb->get_var( $sql );

        if(@$_GET['feed'])
        {
            $feedID = (int)$_GET['feed'];
            $sql .= " AND feed_id = '$feedID' ";
        }

        if(@$_GET['cat'])
        {
            $cat = @$_GET['cat'];
            $sql .= " AND ";
            $sql .= " categories LIKE '%$cat%' ";
            $count = $wpdb->get_var( $sql );
        }
        else if(@$_GET['feed'])
            $count = $wpdb->get_var( $sql );

        if(!@$_GET['feed'])
            update_option("rssimporter_news_count_saved",$count);
    
        return $count;
    }
    /**
    * Returns the count of records in the database.
    *
    * @return null|string
    */
    public static function record_count() {
        global $wpdb;

        

        $sql = "SELECT COUNT(*) FROM {$wpdb->prefix}rssimporter_news as news";
        $sql .= " WHERE status = 0";
 
        $count = $wpdb->get_var( $sql );
        
        update_option("rssimporter_news_count",$count);

        if(@$_GET['feed'])
        {
            $feedID = (int)$_GET['feed'];
            $sql .= " AND news.feed_id = '$feedID' ";
        }

        if(@$_GET['cat'])
        {
            $cat = @$_GET['cat'];
            $sql .= " AND ";
            $sql .= " categories LIKE '%$cat%' ";
            $count = $wpdb->get_var( $sql );
        }
        else if(@$_GET['feed'])
            $count = $wpdb->get_var( $sql );
    
        return $count;
    }
    /**
     * Retrieve news data from the database
     *
     * @param int $per_page
     * @param int $page_number
     *
     * @return mixed
     */
    public static function get_news( $per_page = 10, $page_number = 1 ) {

        global $wpdb;
        
        $sql = "SELECT news.* FROM {$wpdb->prefix}rssimporter_news AS news ";

        if(@$_GET['act'] == 'posted')
        {
            $sql .= "WHERE status = 1";
        }
        else
        {
            $sql .= "WHERE status = 0";
        }

        if(@$_GET['cat'])
        {
            $cat = @$_GET['cat'];
            $sql .= " AND categories LIKE '%$cat%' ";
        }

        if(@$_GET['feed'])
        {
            $feedID = (int)$_GET['feed'];
            $sql .= " AND feed_id = '$feedID' ";
        }

        if ( ! empty( $_REQUEST['orderby'] ) ) {
            $sql .= ' ORDER BY ' . esc_sql( $_REQUEST['orderby'] );
            $sql .= ! empty( $_REQUEST['order'] ) ? ' ' . esc_sql( $_REQUEST['order'] ) : ' ASC';
        }
        else
        {
            if(@$_GET['act'] == 'auto')
            {
                $sql .= ' ORDER BY id asc';

            }
            else
                $sql .= ' ORDER BY id DESC';
        }
        
        $sql .= " LIMIT $per_page";
        
        $sql .= ' OFFSET ' . ( $page_number - 1 ) * $per_page;
        
        $result = $wpdb->get_results( $sql, 'ARRAY_A' );
        
        return $result;
    }

    /** Text displayed when no news data is available */
    public function no_items() {
        _e( 'هیچ اخباری رسد نشده است.', 'sp' );
    }

    /**
     * Method for title column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_title( $item )
    {

        // create a nonce
        $delete_nonce = wp_create_nonce( 'sp_delete_news' );
        $publish_nonce = wp_create_nonce( 'sp_publish_news' );
        $img = '<img style="float: right; margin-left: 5px; border-radius:5px; max-width: 150px;" src="'.$item['thumbnail'].'"/>';

        $title = $img. '<strong>' . $item['title'] . '</strong>';

        $actions = [
        'delete' => sprintf( '<a href="?page=%s&action=%s&news=%s&_wpnonce=%s">حذف برای همیشه</a>', esc_attr( $_REQUEST['page'] ), 'delete', absint( $item['id'] ), $delete_nonce ),
        ];

        if(!@$_GET['act'])
        {
            $actions['publish'] = sprintf( '<a href="?page=%s&action=%s&news=%s&_wpnonce=%s">انتشار</a>', esc_attr( $_REQUEST['page'] ), 'publish', absint( $item['id'] ), $publish_nonce );

        }
        return $title . $this->row_actions( $actions );
    }

    /**
     * Method for title column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_created_at( $item )
    {
        $human = "(".human_time_diff(strtotime($item['created_at']),current_time('U')) . ' پیش'.")";
        
        $date = _jdate(strtotime($item['created_at']));
                
        $now = $date->format(get_option( 'date_format' ));
        return $now.' '. $human ;
    }

    /**
     * Method for categories column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_categories( $item )
    {
        return $item['categories'] ?: "دریافت نشده است";
    }

    /**
     * Method for source column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_source( $item )
    {
        $source = $item['feed_id'];
        $s = Crawler::getSourceByID((int)$source);
        if($s)
        {
            return "<a href='".admin_url('admin.php?page=rssimporter-feeds&action=modify&feed='.$s->id)."' target='_blank'>$s->name</a>";
        }
        else return 'خبرگذاری یافت نشد';
        return $source;
    }

    /**
    * Render a column when no column specific method exists.
    *
    * @param array $item
    * @param string $column_name
    *
    * @return mixed
    */
    public function column_default( $item, $column_name ) {
        switch ( $column_name ) {
            case 'intro':
            case 'id':
                return $item[ $column_name ];
            case 'title':
                return $img . $item[ $column_name ];
                break;
            default:
                return print_r( $item, true ); //Show the whole array for troubleshooting purposes
        }
    }
    /**
    * Render the bulk edit checkbox
    *
    * @param array $item
    *
    * @return string
    */
    function column_cb( $item ) {
        return sprintf(
        '<input type="checkbox" name="bulk-delete[]" value="%s" />', $item['id']
        );
    }
    /**
    * Associative array of columns
    *
    * @return array
    */
    function get_columns() {
        $columns = [
            'cb' => '<input type="checkbox" />',
            'title' => __( 'تیتر', 'sp' ),
            'source' => __( 'خبرگذاری', 'sp' ),
            'categories' => __( 'دسته بندی (اصلی)', 'sp' ),
            'intro' => __( 'متن کوتاه', 'sp' ),
            'created_at' => __( 'تاریخ دریافت خبر', 'sp' ),
        ];

        return $columns;
    }
    /**
    * Columns to make sortable.
    *
    * @return array
    */
    public function get_sortable_columns() {
        $sortable_columns = array(
            'id' => array( 'id', true ),
            'title' => array( 'title', false ),
            'feed_id' => array( 'feed_id', false ),
            'created_at' => array( 'created_at', false ),
        );

        return $sortable_columns;
    }
    /**
    * Returns an associative array containing the bulk action
    *
    * @return array
    */
    public function get_bulk_actions() {
        $actions = [
            'bulk-publish' => 'انتشار',
            'bulk-delete' => 'حذف'
        ];

        return $actions;
    }
    /**
    * Handles data query and filter, sorting, and pagination.
    */
    public function prepare_items() {

        $this->_column_headers = $this->get_column_info();
        
        /** Process bulk action */
        $this->process_bulk_action();

        $per_page = $this->get_items_per_page( 'news_per_page', 15 );
        $current_page = $this->get_pagenum();
        if(@$_GET['act'] == 'posted')
        {
            $total_items = self::record_count_posted();
        }
        else
        {
            $total_items = self::record_count();
        }

        $this->set_pagination_args( [
            'total_items' => $total_items, //WE have to calculate the total number of items
            'per_page' => $per_page //WE have to determine how many items to show on a page
        ] );

        $this->items = self::get_news( $per_page, $current_page );
    }
    public function process_bulk_action() {

        if ( 'publish' === $this->current_action() ) {
            $nonce = esc_attr( $_REQUEST['_wpnonce'] );

            if ( ! wp_verify_nonce( $nonce, 'sp_publish_news' ) ) {
                die( 'Go get a life script kiddies' );
            }
            else {
                $saved = Crawler::publishNewsByID(@$_GET['news']);
                self::record_count();

                wp_redirect( esc_url( add_query_arg() ) );
                echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter').'">';
                exit;
            }
        }
            //Detect when a bulk action is being triggered...
        if ( 'delete' === $this->current_action() ) {
            // In our file that handles the request, verify the nonce.
            $nonce = esc_attr( $_REQUEST['_wpnonce'] );

            if ( ! wp_verify_nonce( $nonce, 'sp_delete_news' ) ) {
                die( 'Go get a life script kiddies' );
            }
            else
            {
                self::delete_news( absint( $_GET['news'] ) );

                wp_redirect( wp_get_referer());
                echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter').'">';
                exit;
            }

        }
        // If the delete bulk action is triggered
        if ( ( isset( $_POST['action'] ) && $_POST['action'] == 'bulk-publish' )
            || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-publish' )
            ) {

            $publish_ids = esc_sql( $_POST['bulk-delete'] ); // bulk-delete == 'checkmark'   

            // loop over the array of record IDs and delete them
            foreach ( $publish_ids as $id ) {
                $saved = Crawler::publishNewsByID(@$id);
            }
            self::record_count();


            wp_redirect( esc_url( add_query_arg() ) );
            echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter').'">';
            exit;
        }

        // If the delete bulk action is triggered
        if ( ( isset( $_POST['action'] ) && $_POST['action'] == 'bulk-delete' )
            || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-delete' )
            ) {

            $delete_ids = esc_sql( $_POST['bulk-delete'] );

            // loop over the array of record IDs and delete them
            foreach ( $delete_ids as $id ) {
            self::delete_news( $id );

            }

            wp_redirect( esc_url( add_query_arg() ) );
            echo ' <meta http-equiv="refresh" content="0;url='.admin_url('admin.php?page=rssimporter').'">';
            exit;
        }
    }


}