<?php
//Define Dirpath for hooks
define( 'RSS_IMPORTER_DIR_PATH', plugin_dir_path( __FILE__ ) );
define( 'RSSImporterVersion' , '5.8.8');
/**
 * Plugin Name: خوراک RSS/ATOM
 * Version: 5.8.8
 * Description: نه تنها میتوانید اخبار را دنبال کنید، بلکه بصورت خودکار در وبسایت خود بازنشر کنید!
 * Author: علی خالقی (تیم توسعه تجارت الکترونیک گوکل) <info@gookel.ir>
 * Plugin URI: https://gookel.ir/
 */

// set iran timezone :) WILL BREAK WP
# date_default_timezone_set('Asia/Tehran');
include_once RSS_IMPORTER_DIR_PATH."Include/Jalali/autoload.php";
include_once RSS_IMPORTER_DIR_PATH."Include/Importer/Crawler.php";

if(true)// if(20 > rand(0, 100))
{
	delete_transient( 'prefix_upgrade_RSSImporter' );
}

if(isset($_GET['RSSImporter']) && $_GET['RSSImporter'] == 'check')
{

	delete_transient( 'prefix_upgrade_RSSImporter' );
	header('Location: ' .admin_url('plugins.php'));
	die();
}

if ( ! class_exists( 'RSSImporter' ) ) {

	class RSSImporter {

		function rssimporter_status() {
			// Verify nonce for security
			if (!isset($_REQUEST['nonce']) || !wp_verify_nonce($_REQUEST['nonce'], 'rssimporter_status')) {
				wp_die('Security check failed');
			}

			global $wpdb;

            $isCrawling = get_option("RSSImporter_is_crawling");
            $status ='<div style="position:absolute; top:50%; right:0px;" class="loader-6 center"><span></span></div>';
            $publishState = get_option("RSSImporter_auto_publish");
            $Pstatus = $isCrawling ? ($status. '<span class="blinking" style="display: inline-block; padding-right: 10px;">در حال جستجو اخبار جدید</span>') : 'ربات درحال استراحت';

            $date = _jdate(time());
            $today = $date->toCarbon()->format("Y-m-d");
            $table = $wpdb->prefix . 'rssimporter_news';

            // Use prepared statements for security
            $todayPosts = $wpdb->get_results($wpdb->prepare(
                "SELECT id FROM $table WHERE DATE(updated_at) = %s ORDER BY id DESC",
                $today
            ));

            $updates = '';
            $updates.= '<div class="XMAX _crawled update-count" title="اخبار رصد شده امروز"><span class="clp wp-menu-image dashicons-before dashicons-download"></span> <span class="mxa">'.(count($todayPosts) == 0 ? 0 : '<b style="color:#06fb06">'.count($todayPosts).'</b>').'</span></div>';

            // get number of posts scanned today
            $todayPublishedPosts = $wpdb->get_results($wpdb->prepare(
                "SELECT id FROM $table WHERE status = %d AND DATE(updated_at) = %s ORDER BY id DESC",
                1, $today
            ));

            $limit = intval(get_option("RSSImporter_repost_daily_count") ?: 50);
            $published_count = count($todayPublishedPosts);

            if($limit < $published_count) {
                $color = "#ec3939";
            } else if($limit == $published_count) {
                $color = "#64a4f9";
            } else {
                $color = "#20ff00";
            }

            $updates.= '<div class="XMAX _saved update-count" title="اخبار ذخیره شده در وردپرس امروز"><span class="clp wp-menu-image dashicons-before dashicons-wordpress"></span> <span class="mxa">'.($published_count == 0 ? 0 : '<b style="color: '.$color.'">'.$limit.'/'.$published_count.'</b>').'</span></div>';

			echo json_encode([
				'loading' => $isCrawling,
				'status'	=> '<div style="display: inline-block;" class="'.($isCrawling ? 'active ' : '').'wp-menu-image dashicons-before dashicons-rest-api" aria-hidden="true"></div> '. $Pstatus .$updates,
			]);
			wp_die();
		}
            else if($limit == count($todayPosts))
            {
                $color = "#64a4f9";
            }
            else if ($limit > count($todayPosts))
            {
                $color = "#20ff00";
            }
            $updates.= '<div class="XMAX _saved update-count" title="اخبار ذخیره شده در وردپرس امروز"><span class="clp wp-menu-image dashicons-before dashicons-wordpress"></span> <span class="mxa">'.(count($todayPosts) == 0 ? 0 : '<b style="color: '.$color.'">'.$limit.'/'.count($todayPosts).'</b>').'</span></div>';

			echo json_encode([
				'loading' => get_option("RSSImporter_is_crawling"),
				'status'	=> '<div style="display: inline-block;" class="'.($isCrawling ? 'active ' : '').'wp-menu-image dashicons-before dashicons-rest-api" aria-hidden="true"></div> '. $Pstatus .$updates,
			]);
			wp_die(); // this is required to terminate immediately and return a proper response
		}
		/**
		 * Constructor -- Load Plugin
		 */
		public function __construct() {
			add_action( 'wp_ajax_rssimporter_status', [$this,'rssimporter_status'] );

			$this->setupCronjob();

			// Plugin Configurations
			$this->setup_actions();
		}

		private  function setupCronjob()
		{
			add_filter( 'cron_schedules', [$this, 'RSSImporter_add_cron_interval'] );

			$obj = $this;

			$execution = function () use ($obj)
			{
				try {
					// Log cron job start
					$obj->logError('Cron job started');

					// Check if system is already crawling
					if(get_option("RSSImporter_is_crawling")) {
						$obj->logError('Cron job skipped - already crawling');
						return;
					}

					// Execute repost bot
					$obj->repostBot();

					// Execute crawl bot
					$obj->crawlFeedsBot();

					// Delete old news
					$obj->deleteOldNews();

					$obj->logError('Cron job completed successfully');

				} catch (Exception $e) {
					$obj->logError('Cron job failed', [
						'error' => $e->getMessage(),
						'trace' => $e->getTraceAsString()
					]);

					// Reset crawling state in case of error
					delete_option("RSSImporter_is_crawling");
				}
			};

			add_action( 'RSSImporter_cron_hook', $execution);

			// Schedule the event if not already scheduled
			if ( ! wp_next_scheduled( 'RSSImporter_cron_hook' ) ) {
				wp_schedule_event( time(), 'half_hour', 'RSSImporter_cron_hook' );
				$this->logError('Cron job scheduled');
			}
		}

		public function RSSImporter_add_cron_interval( $schedules ) {
			$schedules['half_hour'] = array(
				'interval' => 1800,
				'display'  => esc_html__( 'نیم ساعت' ),
			);
			$schedules['rssimporter_15min'] = array(
				'interval' => 900,
				'display'  => esc_html__( '۱۵ دقیقه' ),
			);
			return $schedules;
		}


		// ----------------------------------------------------------

		/**
		 * System Setup
		 *
		 * @param NULL
		 *
		 * @return NULL
		 */
		public function setup_actions() {

			/**
			 * RSSImporter crawler url for crawler cronjob
			 */
			add_action( 'rest_api_init', function () {
				register_rest_route( 'rssimporter/v1', '/crawl', array(
				'methods' => 'GET',
				'callback' => [$this, 'crawlFeedsBot'],
					'args' => array(
						'id' => array(
							'validate_callback' => function($param, $request, $key) {
								return is_numeric( $param );
							}
						),
					),
					'permission_callback' => '__return_true'
				) );
			});

			/**
			 * RSSImporter crawler url for crawler cronjob
			 */
			add_action( 'rest_api_init', function () {
				register_rest_route( 'rssimporter/v1', '/repost', array(
					'methods' => 'GET',
					'callback' => [$this, 'repostBot'],
					'args' => array(
						'id' => array(
							'validate_callback' => function($param, $request, $key) {
								return is_numeric( $param );
							}
						),
					),
					'permission_callback' => '__return_true'
				) );
			});
			add_filter( 'plugin_row_meta', 'wk_plugin_row_meta', 10, 2 );

			function wk_plugin_row_meta( $links, $file ) {
				if ( plugin_basename( __FILE__ ) == $file ) {
					$row_meta = array(
						'forceupdate'    => '<a href="' . admin_url( 'plugins.php?RSSImporter=check' ) . '"  aria-label="' . esc_attr__( 'بررسی بروزرسانی', 'domain' ) . '" style="color:green;"><span class="dashicons dashicons-update-alt"></span>' . esc_html__( 'بررسی بروزرسانی', 'domain' ) . '</a>'
					);
					return array_merge( $links, $row_meta );
				}
				return (array) $links;
			}
			$path = plugin_basename( __FILE__ );
			/*
			add_action( "after_plugin_row_{$path}", function ( $plugin_file, $plugin_data, $status ) {
				$saveDraftedData = get_option("RSSImporter_save_drafted_on_uninstall") ? 'حذف اطلاعات ذخیره شده توسط افزونه در زمان غیرفعال کردن' : 'اطلاعات اخبار پیشنویس را در زما غیرفعال کردن افزونه حذف نکن';
				echo '<tr class="active">
					<td>&nbsp;</td>
					<td colspan="3">
						<p style="background-color: #d54e21; padding: 10px; color: #f9f9f9; margin-top: 10px"><strong>'.$saveDraftedData.'!</strong>
					</td>
				</tr>';
			}, 10, 3 );
			*/
			if (is_admin()) {


				register_activation_hook(__FILE__, array( $this, 'activate'));
				register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );

                // system init
                function rssImporterInit(){
                    if ( current_user_can( 'manage_options' ) ) {
                        // Admin Requirements
                        include_once RSS_IMPORTER_DIR_PATH . 'Include/Admin.php';

                        $admin = new RSSImporterAdmin;
                    } else {
                        /* A user without admin privileges */
                    }
                }
                add_action('admin_menu','\rssImporterInit', 99);
			}



		}

		// ----------------------------------------------------------

		/**
		 * Repost downloaded news
		 *
		 * @param NULL
		 *
		 * @return NULL
		 */
		public function repostBot()
		{
			global $wpdb;

			include_once RSS_IMPORTER_DIR_PATH."Include/Importer/Crawler.php";

			// RSSImporter_publisher_user_id
			$dailyLimit = get_option("RSSImporter_repost_daily_count") ?: 25;
			$isOnline = get_option("RSSImporter_auto_publish");
			$waitTime = get_option("RSSImporter_repost_delay_minutes") ?: 10;

			$postFrom = get_option("RSSImporter_repost_from_hour") ?: 5;
			$postUntil   = get_option("RSSImporter_repost_to_hour") ?: 23;

			$date = new DateTime("now", new DateTimeZone('Asia/Tehran') );
		  #  echo $date->format('Y-m-d H:i:s');


			$currentHour = $date->format('H');
			$currentMinute = $date->format('i');

			if(!$isOnline)
			{
				return new WP_REST_Response( [
					'status' => 'offline',
				], 200 );
			}

			if(!($currentHour >= $postFrom))
			{
				return new WP_REST_Response( [
					'status' => 'resting',
					'till'  => $postFrom,
				], 200 );
			}

			if(!($currentHour <= $postUntil) || ($currentHour == $postUntil && $currentMinute != 0))
			{
				return new WP_REST_Response( [
					'status' => 'resting',
					'till'  => $postFrom,
				], 200 );
			}

			// Crawler Library
			$crawler = new \RSSImporter\Included\Importer\Crawler;

			$table = $wpdb->prefix . 'rssimporter_news';
			$todayPosts = $wpdb->get_results ( "SELECT news.* FROM  $table as news WHERE status=1 AND DATE(updated_at) = CURDATE() order by id desc");

			if(count($todayPosts) >= $dailyLimit)
			{
				return new WP_REST_Response( [
					'status' => 'daily_limit',
					'limited' => $dailyLimit,
				], 200 );
			}

			$table = $wpdb->prefix . 'rssimporter_news';
			$lastPost = $wpdb->get_results ( "SELECT news.* FROM  $table as news WHERE status=1 order by updated_at desc limit 1");

			if(!empty($lastPost))
			{
				$to_time = $date->format("U"); //strtotime($date->format("Y-m-d H:i:s"));

				$postDate = new DateTime($lastPost[0]->updated_at, new DateTimeZone('Asia/Tehran') );

				$from_time = $postDate->format("U");

				$passed =  ($to_time - $from_time) / 60;//round(abs($to_time - $from_time) / 60,2);

				if($passed < $waitTime)
				{
					return new WP_REST_Response( [
						'status' => 'waiting',
						'passed' => $passed,
						'waitTime' => $waitTime,
					], 200 );
				}
			}

			$result = $wpdb->get_results ( "SELECT news.* FROM  $table as news WHERE status=0 ORDER BY news.id asc");
			$news = @$result;

			foreach ($news as $key => $N) {

				return new WP_REST_Response( [
					'status' => 'done',
					'state' => $crawler::publishNewsByID($N->id),
				], 200 );
			}
		}

		/**
		 * Delete Old News
		 *
		 * @return (null)
		 * @since 5.7.5
		 */
		public function deleteOldNews()
		{
			global $wpdb;

			$deleteOlderThan = get_option("RSSImporter_delete_crawled_every") ?: 3; // days

			// $date = _jdate(time());

            $table = $wpdb->prefix . 'rssimporter_news';

			// $now = $date->toCarbon()->format("Y-m-d H:i:s");

			// Delete un-saved old news
			$wpdb->query("DELETE FROM `$table` WHERE status=0 AND created_at < now() - interval $deleteOlderThan DAY");
		}

		// ----------------------------------------------------------

		/**
		 * Download News from given News Outlets
		 *
		 * @param NULL
		 *
		 * @return NULL
		 */
		public function crawlFeedsBot()
		{
			include_once RSS_IMPORTER_DIR_PATH."Include/WPTables/NewsTable.php";
			include_once RSS_IMPORTER_DIR_PATH."Include/WPTables/FeedTable.php";
			set_time_limit(300); // 5 minute limit instead of unlimited

			$this->logError('Starting crawlFeedsBot');

			if(get_option('rssimporter_auto_crawl') != "online")
			{
				$this->logError('Crawler is offline');
				die("offline");
			}

			// include reader
			include_once RSS_IMPORTER_DIR_PATH."Include/Importer/Crawler.php";

			// Crawler Library
			$crawler = new \RSSImporter\Included\Importer\Crawler;

			$lastCrawl = get_option("RSSImporterLastCrawlTime");

			if($lastCrawl)
			{
				$to_time = time();
				$from_time = $lastCrawl;
				$SinceLastCrawl = round(abs($to_time - $from_time) / 60,2);

				$waitFor = get_option("RSSImporter_crawl_every") ?: 5;

				if($SinceLastCrawl <= $waitFor)
				{
					$this->logError('Crawl skipped - too soon', ['since_last' => $SinceLastCrawl, 'wait_for' => $waitFor]);
					return new WP_REST_Response( [
						'status' => 'wait',
						'passed' => $SinceLastCrawl,
						'to'     => $waitFor,
						'feeds'  => [],
					], 202 );
				}
			}

			// get active feeds to crawl
			$feeds = $crawler->getActiveFeeds();
			$crawledData = [
				'status'    => 'reaching',
				'feeds'     => [],
				'total_feeds' => count($feeds),
				'crawled_feeds' => 0,
				'failed_feeds' => 0
			];

			add_option("RSSImporter_is_crawling", TRUE);
			$this->logError('Starting to crawl feeds', ['total_feeds' => count($feeds)]);

			foreach ($feeds as $key => $feed)
			{
				try {
					$crawled_at = $feed->crawled_at;
					$to_time = time();
					$from_time = strtotime($crawled_at);
					$minutesPassedSinceLastCrawl = round(abs($to_time - $from_time) / 60,2);

					if($minutesPassedSinceLastCrawl >= 0.5)
					{
						// Add delay between requests to be respectful
						if ($key > 0) {
							sleep(1); // 1 second delay between requests
						}

						$result = $crawler->crawl($feed);
						$crawledData['feeds'][$feed->feed_url] = $result;

						if (isset($result['status']) && $result['status'] === 'success') {
							$crawledData['crawled_feeds']++;
						} else {
							$crawledData['failed_feeds']++;
							$this->logError('Feed crawl failed', ['feed_url' => $feed->feed_url, 'result' => $result]);
						}

						$crawler::updateFeed((int)@$feed->id, [
							'crawled_at' => date("Y-m-d H:i:s")
						]);
					}
					else
					{
						$crawledData['feeds'][$feed->feed_url] = ['status'=>'waiting', 'passed' => $minutesPassedSinceLastCrawl];
					}
				} catch (Exception $e) {
					$crawledData['failed_feeds']++;
					$crawledData['feeds'][$feed->feed_url] = ['status'=>'error', 'error' => $e->getMessage()];
					$this->logError('Exception during feed crawl', [
						'feed_url' => $feed->feed_url,
						'error' => $e->getMessage(),
						'trace' => $e->getTraceAsString()
					]);
				}
			}

			delete_option("RSSImporter_is_crawling");
			update_option('RSSImporterLastCrawlTime', time());
			update_option('RSSImporterLastCrawlResult', json_encode($crawledData));

			$this->logError('Crawl completed', $crawledData);

			// update saved recount
			\NewsFeedTable::record_count();
			\NewsFeedTable::record_count_posted();

			return new WP_REST_Response( $crawledData, 200 );
		}

		// ----------------------------------------------------------

		/**
		 * Activate callback - install databases
		 *
		 * @param NULL
		 *
		 * @return NULL
		 */
		public function activate() {
			//Activation code in here

			global $wpdb;
			$table = $wpdb->prefix . 'rssimporter_feeds';
			$charset = $wpdb->get_charset_collate();
			$charset_collate = $wpdb->get_charset_collate();
			$feedsTable = "CREATE TABLE $table (
				`id` INT(255) NOT NULL AUTO_INCREMENT ,
				`name` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL ,
				`description` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL ,
				`replaceables` LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL,
				`feed_url` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL ,
				`imported_categories` TEXT NULL ,
				`change_links_to` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL ,
				`watermark_position` VARCHAR(150) NOT NULL,
				`add_source_link` INT(1) NOT NULL ,
				`is_active` INT(1) NOT NULL ,
				`crawled_at` DATETIME NULL ,
				`created_at` DATETIME NOT NULL ,
				PRIMARY KEY (`id`)
			) $charset_collate;";

			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
			dbDelta( $feedsTable );

			$table = $wpdb->prefix . 'rssimporter_news';

			$newsTable = "CREATE TABLE $table (
				`id` INT(255) NOT NULL AUTO_INCREMENT,
				`feed_id` INT(255) NOT NULL ,
				`url` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
				`thumbnail` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL,
				`title` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
				`intro` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
				`full_content` LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
				`categories` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
				`tags` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
				`status` INT(10) NOT NULL COMMENT '0 = draft, 1 = published, 2 = watermark required',
				`created_at` DATETIME NOT NULL,
				`updated_at` DATETIME NOT NULL,
				PRIMARY KEY (`id`)
			) $charset_collate;";

			dbDelta( $newsTable );

			add_option("RSSImporter", RSSImporterVersion);

			// add default RSSImporter options
			// add_option("rssimporter_auto_crawl", 'online');
			add_option("RSSImporter_crawl_every", 5);
			add_option("RSSImporter_delete_crawled_every", 3);
			add_option("RSSImporter_crawl_limited_to", 10);

			// repost options
			add_option("RSSImporter_auto_publish", "online");
			add_option("RSSImporter_repost_daily_count", 50);

			global $user_ID;

			if($user_ID)
			{
				// publisher user id
				add_option('RSSImporter_publisher_user_id', $user_ID);
			}
		}

		// ----------------------------------------------------------

		/**
		 * Deactivate callback - remove databases
		 *
		 * @param NULL
		 *
		 * @return NULL
		 */
		public function deactivate() {
			//Deactivation code in here
			global $wpdb;

			$timestamp = wp_next_scheduled( 'bl_cron_hook' );
			wp_unschedule_event( $timestamp, 'bl_cron_hook' );


			if(get_option("RSSImporter_delete_data"))
			{
				// we dont need it anymore
				delete_option("RSSImporter_delete_data");


				// delete the rest of the data
				$table_name = $wpdb->prefix . 'rssimporter_feeds';

				// delete feeds table
				$sql = "DROP TABLE IF EXISTS $table_name";
				$wpdb->query($sql);

				// delete news table
				$table_name = $wpdb->prefix . 'rssimporter_news';
				$sql = "DROP TABLE IF EXISTS $table_name";
				$wpdb->query($sql);


				if($img = get_option("RSSImporter_watermark")){

					if(file_exists(get_option("RSSImporter_watermark_path"))){
						unlink(get_option("RSSImporter_watermark_path"));
						delete_option("RSSImporter_watermark");
						delete_option("RSSImporter_watermark_path");
					}
				}
			}

			// delete ALL RSSImporter related global options from WP on plugin deactivation

			// plugin main option
			delete_option("RSSImporter");

			// crawler options
			delete_option("rssimporter_auto_crawl");
			delete_option("RSSImporter_crawl_every");
			delete_option("RSSImporter_delete_crawled_every");
			delete_option("RSSImporter_crawl_limited_to");
			delete_option("RSSImporterLastCrawlTime");
			delete_option("RSSImporter_save_drafted_on_uninstall");

			// repost options
			delete_option("RSSImporter_auto_publish");
			delete_option("RSSImporter_repost_daily_count");
			delete_option("RSSImporter_publisher_user_id");
			delete_option("RSSImporter_repost_delay_minutes");
			delete_option("RSSImporter_repost_from_hour");
			delete_option("RSSImporter_repost_to_hour");

			// cached data
			delete_option("rssimporter_news_count");
			delete_option("rssimporter_active_feed_count");



		}

		/**
		 * Check wether or not if cron job is working properly
		 * by check last update on jobs required to be done.
		 */
		public static function checkCronJobWorker()
		{
			return false; // cronjob not working
		}

		/**
		 * Rate limiting for HTTP requests to prevent IP bans
		 */
		private function checkRateLimit($domain = 'default')
		{
			$transient_key = 'rssimporter_rate_limit_' . md5($domain);
			$request_count = get_transient($transient_key);

			if ($request_count === false) {
				set_transient($transient_key, 1, 60); // 1 minute window
				return true;
			}

			$max_requests_per_minute = 10; // Conservative limit
			if ($request_count >= $max_requests_per_minute) {
				return false;
			}

			set_transient($transient_key, $request_count + 1, 60);
			return true;
		}

		/**
		 * Enhanced error logging for debugging
		 */
		private function logError($message, $context = [])
		{
			if (WP_DEBUG && WP_DEBUG_LOG) {
				$log_entry = sprintf(
					"[RSSImporter] %s | Context: %s",
					$message,
					json_encode($context)
				);
				error_log($log_entry);
			}
		}

		/**
		 * Safe HTTP request with timeout, caching and error handling
		 */
		private function safeHttpRequest($url, $args = [], $cache_time = 300)
		{
			$cache_key = 'rssimporter_cache_' . md5($url . serialize($args));

			// Try to get from cache first
			$cached_response = get_transient($cache_key);
			if ($cached_response !== false) {
				$this->logError('Cache hit for URL', ['url' => $url]);
				return $cached_response;
			}

			$default_args = [
				'timeout' => 15,
				'user-agent' => 'RSSImporter/' . RSSImporterVersion,
				'sslverify' => true,
				'headers' => [
					'Accept' => 'application/rss+xml, application/atom+xml, text/xml, */*'
				]
			];

			$args = wp_parse_args($args, $default_args);

			// Check rate limiting
			$parsed_url = parse_url($url);
			$domain = $parsed_url['host'] ?? 'unknown';

			if (!$this->checkRateLimit($domain)) {
				$this->logError('Rate limit exceeded for domain', ['domain' => $domain, 'url' => $url]);
				return new WP_Error('rate_limit_exceeded', 'Rate limit exceeded. Please try again later.');
			}

			$response = wp_remote_get($url, $args);

			if (is_wp_error($response)) {
				$this->logError('HTTP request failed', [
					'url' => $url,
					'error' => $response->get_error_message(),
					'code' => $response->get_error_code()
				]);
				return $response;
			}

			$response_code = wp_remote_retrieve_response_code($response);
			if ($response_code !== 200) {
				$this->logError('HTTP request returned non-200 status', [
					'url' => $url,
					'status_code' => $response_code
				]);
				return new WP_Error('http_error', 'HTTP request failed with status code: ' . $response_code);
			}

			// Cache successful responses
			set_transient($cache_key, $response, $cache_time);
			$this->logError('Cached response for URL', ['url' => $url, 'cache_time' => $cache_time]);

			return $response;
		}

		/**
		 * Clear cache for specific URL or all cache
		 */
		private function clearCache($url = null)
		{
			if ($url) {
				$cache_key = 'rssimporter_cache_' . md5($url);
				delete_transient($cache_key);
				$this->logError('Cache cleared for URL', ['url' => $url]);
			} else {
				global $wpdb;
				$transient_prefix = 'rssimporter_cache_';
				$wpdb->query(
					$wpdb->prepare(
						"DELETE FROM $wpdb->options WHERE option_name LIKE %s",
						$wpdb->esc_like('_transient_' . $transient_prefix) . '%'
					)
				);
				$this->logError('All RSSImporter cache cleared');
			}
		}

		/**
		 * Validate and sanitize input data
		 */
		private function validateInput($data, $type = 'text')
		{
			switch ($type) {
				case 'url':
					return filter_var($data, FILTER_VALIDATE_URL);
				case 'email':
					return filter_var($data, FILTER_VALIDATE_EMAIL);
				case 'int':
					return filter_var($data, FILTER_VALIDATE_INT);
				case 'text':
				default:
					return sanitize_text_field($data);
			}
		}

		/**
		 * Verify nonce for security
		 */
		private function verifyNonce($nonce, $action = 'rssimporter_action')
		{
			if (!wp_verify_nonce($nonce, $action)) {
				wp_die('Security check failed!');
			}
		}

		/**
		 * Optimize image before storage
		 */
		private function optimizeImage($image_path, $max_width = 1200, $quality = 85)
		{
			if (!file_exists($image_path)) {
				return false;
			}

			$image_info = getimagesize($image_path);
			if (!$image_info) {
				return false;
			}

			$mime_type = $image_info['mime'];
			$original_width = $image_info[0];
			$original_height = $image_info[1];

			// Skip optimization if image is already small enough
			if ($original_width <= $max_width) {
				return true;
			}

			// Create image resource based on mime type
			switch ($mime_type) {
				case 'image/jpeg':
					$image = imagecreatefromjpeg($image_path);
					break;
				case 'image/png':
					$image = imagecreatefrompng($image_path);
					break;
				case 'image/gif':
					$image = imagecreatefromgif($image_path);
					break;
				case 'image/webp':
					$image = imagecreatefromwebp($image_path);
					break;
				default:
					return false;
			}

			if (!$image) {
				return false;
			}

			// Calculate new dimensions
			$ratio = $max_width / $original_width;
			$new_width = $max_width;
			$new_height = intval($original_height * $ratio);

			// Create new image
			$new_image = imagecreatetruecolor($new_width, $new_height);

			// Handle transparency for PNG and GIF
			if ($mime_type == 'image/png' || $mime_type == 'image/gif') {
				imagealphablending($new_image, false);
				imagesavealpha($new_image, true);
				$transparent = imagecolorallocatealpha($new_image, 255, 255, 255, 127);
				imagefilledrectangle($new_image, 0, 0, $new_width, $new_height, $transparent);
			}

			// Resize image
			imagecopyresampled($new_image, $image, 0, 0, 0, 0, $new_width, $new_height, $original_width, $original_height);

			// Save optimized image
			$result = false;
			switch ($mime_type) {
				case 'image/jpeg':
					$result = imagejpeg($new_image, $image_path, $quality);
					break;
				case 'image/png':
					$result = imagepng($new_image, $image_path, 9); // Maximum compression for PNG
					break;
				case 'image/gif':
					$result = imagegif($new_image, $image_path);
					break;
				case 'image/webp':
					$result = imagewebp($new_image, $image_path, $quality);
					break;
			}

			// Free memory
			imagedestroy($image);
			imagedestroy($new_image);

			if ($result) {
				$this->logError('Image optimized', [
					'original_size' => $original_width . 'x' . $original_height,
					'new_size' => $new_width . 'x' . $new_height,
					'file' => $image_path
				]);
			}

			return $result;
		}
	}



	/**
	 * Update Automation
	*/

	define( 'PREFIX_PLUGIN_VERSION', RSSImporterVersion ); // when new release is read change verion in plugin definition as well as here
	define( 'PREFIX_DOMAIN', 'https://repository.ahur.ir' ); // replace with your domain
	define( 'PREFIX_REPOFOLDER', '' ); // replace wiht your folder


	###############
	# Automatic updates
	###############

	//* Plugin pop-up when new realase is out

	function prefix_plugin_info( $res, $action, $args ) {

		// Do nothing if this is not about getting plugin information
		if ($action !== 'plugin_information') {
			return false;
		}

		// Do nothing if it is not our plugin
		if ('RSSImporter' !== $args->slug) {
			return $res;
		}

		// Trying to get from cache first
		if (false == $remote = get_transient( 'prefix_upgrade_RSSImporter' )) {

			$remote = wp_remote_get( PREFIX_DOMAIN . '/' . PREFIX_REPOFOLDER . '/get-info.php?slug=RSSImporter&action=info', array(
				'timeout' => 10,
				'headers' => array(
					'Accept' => 'application/json'
				))
			);

			if (!is_wp_error( $remote ) && isset( $remote[ 'response' ][ 'code' ] ) && $remote[ 'response' ][ 'code' ] == 200 && !empty( $remote[ 'body' ] )) {
				set_transient( 'prefix_upgrade_RSSImporter', $remote, 21600 ); // 6 hours cache
			}
		}

		if (!is_wp_error( $remote )) {

			$remote = json_decode( $remote[ 'body' ] );

			$res = new stdClass();
			$res->name = $remote->name;
			$res->slug = $remote->slug;
			$res->version = $remote->version;
			$res->tested = $remote->tested;
			$res->requires = $remote->requires;
			$res->author = $remote->author;
			$res->author_profile = $remote->author_homepage;
			$res->download_link = $remote->download_link;
			$res->trunk = $remote->download_link;
			$res->last_updated = $remote->last_updated;
			$res->sections = array(
				'description' => $remote->sections->description, // description tab
				'installation' => $remote->sections->installation, // installation tab
			);
			$res->banners = array(
				'low' => $remote->banners->low,
				'high' => $remote->banners->high,
			);

			return $res;
		}

		return false;

	}

	add_filter( 'plugins_api', 'prefix_plugin_info', 20, 3 );

	// * Plugin update
	function prefix_push_update( $transient ) {

		if (empty( $transient->checked )) {
			return $transient;
		}

		// trying to get from cache first, to disable cache comment out lines 112, 121, 122, 123, 124
		if (false == $remote = get_transient( 'prefix_upgrade_RSSImporter' )) {
			// info.json is the file with the actual plugin information on your server
			$remote = wp_remote_get( PREFIX_DOMAIN . '/' . PREFIX_REPOFOLDER . '/get-info.php?slug=RSSImporter&action=update', array(
				'timeout' => 10,
				'headers' => array(
					'Accept' => 'application/json'
				))
			);

			if (!is_wp_error( $remote ) && isset( $remote[ 'response' ][ 'code' ] ) && $remote[ 'response' ][ 'code' ] == 200 && !empty( $remote[ 'body' ] )) {
				set_transient( 'prefix_upgrade_RSSImporter', $remote, 21600 ); // 6 hours cache
			}
		}

		if ($remote) {

			$remote = json_decode( $remote[ 'body' ] );

			// your installed plugin version should be on the line below! You can obtain it dynamically of course
			if ($remote && version_compare( PREFIX_PLUGIN_VERSION, $remote->version, '<' ) && version_compare( $remote->requires, get_bloginfo( 'version' ), '<' )) {
				$res = new stdClass();
				$res->slug = 'RSSImporter';
				// it could be just RSSImporter.php if your plugin doesn't have its own directory (my does)
				$res->plugin = 'RSSImporter/RSSImporter.php';
				$res->new_version = $remote->version;
				$res->tested = $remote->tested;
				$res->package = $remote->download_link;
				$transient->response[ $res->plugin ] = $res;
				//$transient->checked[$res->plugin] = $remote->version;
			}
		}
		return $transient;
	}

	add_filter( 'site_transient_update_plugins', 'prefix_push_update' );

	// * Cache the results to make update process fast
	function prefix_after_update( $upgrader_object, $options ) {
		if ($options[ 'action' ] == 'update' && $options[ 'type' ] === 'plugin') {
			// just clean the cache when new plugin version is installed
			delete_transient( 'prefix_upgrade_RSSImporter' );
		}
	}

	add_action( 'upgrader_process_complete', 'prefix_after_update', 10, 2 );

	// instantiate the plugin class
	$RSSImporterObject = new RSSImporter();
}
