<form method="post" class="wrap ui form">
    <h1 class="wp-heading-inline">ویرایش خبرگذاری ( <?=$feed->name?> )</h1>

    <div class="wp-header-end ui divider"></div>

    <div class="ui stackable equal width grid">
        <div class="four wide column">

            <div class="ui segments">

                <div class="ui secondary segment">
                    اطلاعات RSS
                </div>
                <div class="ui segment">
                    <span class="ltr ui fluid icon labeled label"><i class="world icon"></i> <?=$feed->feed_url?></span>
                </div>
                <div class="ui segment">
                    <span class="ui fluid label"><?=$feed->description?></span>
                </div>
                <div class="ui segment">
                    <span class="ui fluid <?=$feed->is_active == 1 ? 'green' : 'red' ?> label"><?=$feed->is_active == 1 ? 'روشن' : 'خاموش?>'?></span>
                </div>
            </div>
        </div>
        <div class="column">
            <div class="ui segments">

                <div class="ui secondary segment">
                    <i class="cogs icon"></i> تنظیمات خبرگذاری
                </div>
                <div class="ui segment">

                    <form method="post" class="ui raised segment form">
                        <input name="name" value="<?=@$Feed->title?>"  type="hidden">
                        <input name="description" value="<?=@$Feed->description?>"  type="hidden">
                        <input name="feed_url" value="<?=@$_POST['feed_url']?>"  type="hidden">
                        <input type="hidden" name='action' value='save' />
                        <?php
                        $args = array(
                            'show_option_none' => __( 'انتخاب دسته بندی', 'textdomain' ),
                            'show_count'       => 1,
                            'orderby'          => 'name',
                            "hide_empty" => 0,
                            'echo'             => 0,
                        );
                        if($feed->imported_categories)
                        {
                            $args['selected'] = $feed->imported_categories;
                        }
                        
                        /*
                        $select  = wp_dropdown_categories( $args );
                        $replace = "<select$1 onchange='return this.form.submit()'>"; 
                        $select  = preg_replace( '#<select([^>]*)>#', $replace, $select ); 
                        */
                        $select  = wp_dropdown_categories( $args );
                        
                        ?>
                        <div class="field">
                            <label><input type="checkbox" <?=$feed->imported_categories ? 'checked="checked"' : ''?>  name="select_category" /> انتخاب دسته برای اخبار این فید</label>
                        </div>
                        <div style="<?=!$feed->imported_categories ? 'display: none' : ''?>;" id="selectCat" class="">
                            <?=$select?> 
                        </div>

                    </div>
                    <div class="ui secondary segment">

                        <div class="field">
                            <label>ویرایش متن</label>
                        </div>
                        <?php
                        foreach (json_decode($feed->replaceables, TRUE) as $key => $value) {
                            ?>
                        <div class="two fields">
                            <div class="field">
                                <label>واژه هدف</label>
                                <div class="ui left icon input">
                                    <input name="replace_from[]" value="<?=$key?>" placeholder="واژه هدف" class="rtl" type="text">
                                    <i class="edit icon"></i>
                                </div>
                            </div>
                            <div class="field">
                                <label>واژه جدید</label>
                                <div class="ui left icon input">
                                    <input name="replace_to[]" value="<?=$value?>" placeholder="واژه جدید" class="rtl" type="text">
                                    <i class="edit icon"></i>
                                </div>
                            </div>
                        </div>
                            <?php
                        }
                        ?>
                        <div class="two fields clsp">
                            <div class="field">
                                <label>واژه هدف</label>
                                <div class="ui left icon input">
                                    <input name="replace_from[]" placeholder="واژه هدف" class="rtl" type="text">
                                    <i class="edit icon"></i>
                                </div>
                            </div>
                            <div class="field">
                                <label>واژه جدید</label>
                                <div class="ui left icon input">
                                    <input name="replace_to[]" placeholder="واژه جدید" class="rtl" type="text">
                                    <i class="edit icon"></i>
                                </div>
                            </div>
                        </div>
                        <div class="field xcs">
                            <span class="ui basic teal icon labeled button dpo"> <i class="add icon"></i> جایگزین متن جدید</span>
                        </div>
                    </div>

                    <div class="ui segment">
                        <div class="field">
                            <label><input type="checkbox" <?=$feed->change_links_to ? 'checked="checked"' : ''?>  name="change_links_to" /> تغییر لینک به آدرس زیر</label>
                        </div>
                        <div class="field" style="<?=$feed->change_links_to ? '' : 'display: none;'?> " id="changeLinkTo">
                            <label>آدرس لینک جدید</label>
                            
                            <div class="ui left icon input">
                                <input name="change_links_to_url" value="<?=$feed->change_links_to?>" type="text">
                                <i class="world icon"></i>
                            </div>
                        </div>
                        <div class="field">
                            <label><input type="checkbox" <?=$feed->watermark_position ? 'checked="checked"' : ''?> name="watermark" /> ثبت واترمارک</label>
                        </div>
                        <div class="two fields" style="<?=$feed->watermark_position ? '' : 'display: none;'?>" id="watermarkSetting">

                            <div class="field">
                                <select name="watermark_position">
                                    <option <?=$feed->watermark_position == 'POSITION_TOP_LEFT' ? 'selected' : ''?> value="POSITION_TOP_LEFT">بالا چپ</option>
                                    <option <?=$feed->watermark_position == 'POSITION_TOP' ? 'selected' : ''?> value="POSITION_TOP">بالا وسط</option>
                                    <option <?=$feed->watermark_position == 'POSITION_TOP_RIGHT' ? 'selected' : ''?> value="POSITION_TOP_RIGHT">بالا راست</option>
                                    <option <?=$feed->watermark_position == 'POSITION_LEFT' ? 'selected' : ''?> value="POSITION_LEFT">چپ</option>
                                    <option <?=$feed->watermark_position == 'POSITION_CENTER' ? 'selected' : ''?> value="POSITION_CENTER">وسط</option>
                                    <option <?=$feed->watermark_position == 'POSITION_RIGHT' ? 'selected' : ''?> value="POSITION_RIGHT">راست</option>
                                    <option <?=$feed->watermark_position == 'POSITION_BOTTOM_LEFT' ? 'selected' : ''?> value="POSITION_BOTTOM_LEFT">پاین چپ</option>
                                    <option <?=$feed->watermark_position == 'POSITION_BOTTOM' ? 'selected' : ''?> value="POSITION_BOTTOM">پایین وسط</option>
                                    <option <?=$feed->watermark_position == 'POSITION_BOTTOM_RIGHT' ? 'selected' : ''?> value="POSITION_BOTTOM_RIGHT">پایین راست</option>
                                </select>
                            </div>
                            <div class="field">
                                
                                <?php
                                $watermarkImg = get_option("RSSImporter_watermark");
                                if(empty($watermarkImg))
                                {
                                    echo "<div class='ui red message'>تصویر واترمارک خبرگذاری شما آپلود نشده است، جهت آپلود کلیک کنید.</div>";
                                }
                                else
                                {
                                    
                                    ?>
                                    <img src="<?=$watermarkImg?>"/>    
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        
                        <div class="field">
                            <label><input type="checkbox" <?=$feed->add_source_link ? 'checked="checked"' : ''?> name="add_source_link" /> درج نام و لینک منبع اصلی در انتهای خبر ذخیره شده</label>
                        </div>
                        <button name="save" value="true" class="ui basic button">ویرایش منبع</button>
                    </form>
                </div> 
            </div>
        </div>
    </div>
</form>

<script>
    
jQuery(document).ready(function(){
    
    jQuery(".dpo").click(function(){
        var s = jQuery(".clsp").clone();
        s.removeClass("clsp");
        jQuery('.xcs').before(s);
    })

    jQuery('[name="select_category"]').change(function(){
        if(jQuery(this).is(":checked"))
            jQuery("#selectCat").show();
        else
            jQuery("#selectCat").hide();

    })
    jQuery('[name="change_links_to"]').change(function(){
        if(jQuery(this).is(":checked"))
            jQuery("#changeLinkTo").show();
        else
            jQuery("#changeLinkTo").hide();
        
    })
    jQuery('[name="watermark"]').change(function(){
        if(jQuery(this).is(":checked"))
            jQuery("#watermarkSetting").show();
        else
            jQuery("#watermarkSetting").hide();
    })
    jQuery('[name="add_source_link"]').change(function(){
        
    })
})
</script>