<?php
/**
 * Uninstall script for WP WordWeaver
 * This file is executed when the plugin is deleted
 */

// If uninstall not called from WordPress, then exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * Clean up plugin data on uninstall
 */
function wp_wordweaver_uninstall() {
    global $wpdb;

    // Delete plugin options
    delete_option('wp_wordweaver_options');

    // Delete all plugin-related post meta
    $meta_keys = array(
        '_wp_wordweaver_processed',
        '_wp_wordweaver_original_content',
        '_wp_wordweaver_processing_type',
        '_wp_wordweaver_auto_process',
        '_wp_wordweaver_instructions'
    );

    foreach ($meta_keys as $meta_key) {
        $wpdb->delete($wpdb->postmeta, array('meta_key' => $meta_key));
    }

    // Delete any custom database tables if they exist in future versions
    // $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}wordweaver_logs");

    // Clear any cached data
    wp_cache_flush();

    // Delete transients
    $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_wp_wordweaver_%'");
    $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_wp_wordweaver_%'");

    // Log uninstall (if debugging is enabled)
    if (defined('WP_DEBUG') && WP_DEBUG) {
        error_log('[WP WordWeaver] Plugin uninstalled and all data cleaned up');
    }
}

// Run the uninstall function
wp_wordweaver_uninstall();
